#!/bin/sh

. ./_xfceset.sh

APPNAME=vte
VER=0.28.2
TARGET=$APPNAME-$VER
TARGETBALL=$XFCEDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	gtk+-2 intltool
. $WRK/_checkOptions.sh  \
	gobject-introspection gtk-doc pygtk
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
	--libexecdir=/usr/lib/vte \
	--disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

