#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=2.15
TARGET=eglibc-$VER
TARGETBALL=$DLD/$TARGET-r21467.tar.xz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

cd $SRC

RemoveSrcDir
rm -fr eglibc-build
Extract

TimeStart

cd $TARGETDIR

sed -i 's/\(&& $name ne\) "db1"/ & \1 "nss_test1"/' scripts/test-installation.pl

LINKER=$(readelf -l /tools/bin/bash | sed -n 's@.*interpret.*/tools\(.*\)]$@\1@p')
sed -i "s|libs -o|libs -L/usr/lib64 -Wl,-dynamic-linker=${LINKER} -o|" \
  scripts/test-installation.pl
unset LINKER

echo Patching...
patch -Np1 -i $DLD/eglibc-$VER-fixes-1.patch \
        1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

mkdir -v ../eglibc-build
cd ../eglibc-build

echo "slibdir=/lib64" >> configparms

echo Configuring...
CC="gcc ${BUILD64}" CXX="g++ ${BUILD64}" \
    CFLAGS="-mtune=generic -g -O2" \
    ../eglibc-$VER/configure --prefix=/usr \
    --disable-profile --enable-kernel=2.6.32 \
    --libexecdir=/usr/lib64/eglibc --libdir=/usr/lib64 \
        1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo Making...
make \
        1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo Installing...
#paco -p $TARGET "\
#make install" \
make install \
        1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

cp -v ../eglibc-$VER/sunrpc/rpc/*.h /usr/include/rpc
cp -v ../eglibc-$VER/sunrpc/rpcsvc/*.h /usr/include/rpcsvc
cp -v ../eglibc-$VER/nis/rpcsvc/*.h /usr/include/rpcsvc

mkdir -pv /usr/lib/locale
localedef -i cs_CZ -f UTF-8 cs_CZ.UTF-8
localedef -i de_DE -f ISO-8859-1 de_DE
localedef -i de_DE@euro -f ISO-8859-15 de_DE@euro
localedef -i en_HK -f ISO-8859-1 en_HK
localedef -i en_PH -f ISO-8859-1 en_PH
localedef -i en_US -f ISO-8859-1 en_US
localedef -i es_MX -f ISO-8859-1 es_MX
localedef -i fa_IR -f UTF-8 fa_IR
localedef -i fr_FR -f ISO-8859-1 fr_FR
localedef -i fr_FR@euro -f ISO-8859-15 fr_FR@euro
localedef -i it_IT -f ISO-8859-1 it_IT
localedef -i ja_JP -f EUC-JP ja_JP
localedef -i ja_JP -f UTF-8 ja_JP.UTF-8

cat > /etc/nsswitch.conf << "EOF"
# Begin /etc/nsswitch.conf

passwd: files
group: files
shadow: files

hosts: files dns
networks: files

protocols: files
services: files
ethers: files
rpc: files

# End /etc/nsswitch.conf
EOF

tzselect

cp -v --remove-destination /usr/share/zoneinfo/Japan \
    /etc/localtime

cat > /etc/ld.so.conf << "EOF"
# Begin /etc/ld.so.conf

/usr/local/lib
/usr/local/lib64
/opt/lib
/opt/lib64

# End /etc/ld.so.conf
EOF

TimeEnd

cd ..
RemoveSrcDir
rm -fr eglibc-build
