#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=4.6.3
TARGET=gcc-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $CHAP: $TARGET

cd $SRC

RemoveSrcDir
rm -fr gcc-build
Extract
TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/gcc-$VER-branch_update-2.patch \
	1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

sed -i 's/install_to_$(INSTALL_DEST) //' libiberty/Makefile.in

mkdir -v ../gcc-build
cd ../gcc-build

echo Configuring...
CC="gcc -isystem /usr/include ${BUILD64}" \
CXX="g++ -isystem /usr/include ${BUILD64}" \
LDFLAGS="-Wl,-rpath-link,/usr/lib64:/lib64:/usr/lib:/lib" \
  ../gcc-4.6.3/configure --prefix=/usr --libdir=/usr/lib64 \
    --libexecdir=/usr/lib64 --enable-shared --enable-threads=posix \
    --enable-__cxa_atexit --enable-c99 --enable-long-long \
    --enable-clocale=gnu --enable-languages=c,c++ --disable-libstdcxx-pch \
    --enable-cloog-backend=isl \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -sv ../usr/bin/cpp /lib" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -sv gcc /usr/bin/cc" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
rm -fr gcc-build
PacoingDone
