#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=2.22.1
TARGET=util-linux-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

cd $SRC

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
CC="gcc ${BUILD32}" ./configure --libdir=/lib \
    --enable-write --disable-login --disable-su \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone
