#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=1.0.6
TARGET=bzip2-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

cd $SRC

RemoveSrcDir
rm -f /usr/lib/libbz2.so
Extract
TimeStart

cd $TARGETDIR

sed -i -e 's:ln -s -f $(PREFIX)/bin/:ln -s :' Makefile

echo Making...
make -f Makefile-libbz2_so CC="gcc ${BUILD32}" CXX="g++ ${BUILD32}" \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1
make clean \
	1>> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1
make CC="gcc ${BUILD32}" CXX="g++ ${BUILD32}" libbz2.a \
	1>> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
cp -v libbz2.a /usr/lib" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
cp -av libbz2.so* /lib" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -sv ../../lib/libbz2.so.1.0 /usr/lib/libbz2.so" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

