#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=5.0.4
TARGET=xz-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

cd $SRC

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
CC="gcc ${BUILD32}" ./configure --prefix=/usr --libdir=/lib \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make pkgconfigdir=/usr/lib/pkgconfig install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
mv -v /usr/bin/{xz,lzma,lzcat,unlzma,unxz,xzcat} /bin" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
mv -v /lib/liblzma.a /usr/lib" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

