#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=2.15
TARGET=eglibc-$VER
TARGETBALL=$TARGET-r21467.tar.xz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR
rm -fr eglibc-build

. $WRK/_extract.sh

cd $TARGETDIR

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cp -v Makeconfig{,.orig}
sed -e 's/-lgcc_eh//g' Makeconfig.orig > Makeconfig

mkdir -v ../eglibc-build
cd ../eglibc-build

cat > config.cache << "EOF"
libc_cv_forced_unwind=yes
libc_cv_c_cleanup=yes
libc_cv_gnu89_inline=yes
libc_cv_ssp=no
EOF

echo \ \ Configuring...
BUILD_CC="gcc" CC="${CLFS_TARGET}-gcc ${BUILD32}" \
    AR="${CLFS_TARGET}-ar" RANLIB="${CLFS_TARGET}-ranlib" \
    CFLAGS="-march=$(cut -d- -f1 <<< $CLFS_TARGET32) -mtune=generic -g -O2" \
    ../eglibc-2.15/configure --prefix=/tools \
    --host=${CLFS_TARGET32} --build=${CLFS_HOST} \
    --disable-profile --with-tls --enable-kernel=2.6.32 --with-__thread \
    --with-binutils=/cross-tools/bin --with-headers=/tools/include \
    --cache-file=config.cache \
        1> $LOG/$CHAP.$TARGET.1_mrproper.log 2>&1 || exit 1

echo \ \ Making...
make \
        1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
make install inst_vardbdir=/tools/var/db \
        1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
        >> $TME/clfstime.txt

echo \ \ Removing Directory...
cd .. && rm -fr $TARGETDIR
rm -fr eglibc-build

echo \ \ Done.

