#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=5.45
TARGET=expect-$VER
TARGETBALL=expect$VER.tar.gz
TARGETDIR=expect$VER

echo $CHAP: $TARGET

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo \ \ Configuring...
CC="gcc ${BUILD64}" ./configure --prefix=/tools \
   --with-tcl=/tools/lib64 --with-tclinclude=/tools/include  \
   --libdir=/tools/lib64 \
        1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
        1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
make SCRIPTS="" install \
        1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
        >> $TME/clfstime.txt

echo \ \ Removing Directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

