#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

APPNAME=binutils
VER=2.24
TARGET=binutils-$VER
TARGETBALL=${TARGET}.tar.bz2
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR
rm -fr binutils-build

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

rm -fv etc/standards.info
sed -i.bak '/^INFO/s/standards.info //' etc/Makefile.in

mkdir -v ../binutils-build
cd ../binutils-build

echo \ \ Configuring...
../binutils-$VER/configure --prefix=/usr \
    --enable-shared \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make tooldir=/usr \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "make tooldir=/usr install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap6

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR
rm -fr binutils-build

echo \ \ Done.

