#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

APPNAME=mpfr
VER=3.1.2
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Configuring...
./configure --prefix=/usr        \
            --enable-thread-safe \
            --docdir=/usr/share/doc/mpfr-$VER \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

#echo \ \ Checking...
#make check \
#	1> $LOG/$CHAP.$TARGET.3_check.log 2>&1 || echo Error occured in checking

echo \ \ Installing...
paco -p $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1

paco -p+ $TARGET "make html" \
	1> $LOG/$CHAP.$TARGET.5_make.log 2>&1 || exit 1

paco -p+ $TARGET "make install-html" \
	1> $LOG/$CHAP.$TARGET.6_install.log 2>&1 || exit 1

TimeEnd chap6

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

