#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

APPNAME=gcc
VER=4.8.2
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR
rm -fr gcc-build

. $WRK/_extract.sh

cd $TARGETDIR

case `uname -m` in
  i?86) sed -i 's/^T_CFLAGS =$/& -fomit-frame-pointer/' gcc/Makefile.in ;;
esac

sed -i -e /autogen/d -e /check.sh/d fixincludes/Makefile.in
mv -v libmudflap/testsuite/libmudflap.c++/pass41-frag.cxx{,.disable}

TimeStart

mkdir -v ../gcc-build
cd ../gcc-build

echo \ \ Configuring...
SED=sed                          \
../gcc-$VER/configure           \
     --prefix=/usr               \
     --enable-shared             \
     --enable-threads=posix      \
     --enable-__cxa_atexit       \
     --enable-clocale=gnu        \
     --enable-languages=c,c++    \
     --disable-multilib          \
     --disable-bootstrap         \
     --with-system-zlib          \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
ln -sv ../usr/bin/cpp /lib" \
	1>> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
ln -sv gcc /usr/bin/cc" \
	1>> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1

echo 'main(){}' > dummy.c
cc dummy.c -v -Wl,--verbose &> dummy.log
readelf -l a.out | grep ': /lib'

grep -o '/usr/lib.*/crt[1in].*succeeded' dummy.log

grep -B4 '^ /usr/include' dummy.log

grep 'SEARCH.*/usr/lib' dummy.log |sed 's|; |\n|g'

grep "/lib.*/libc.so.6 " dummy.log

grep found dummy.log

rm -v dummy.c a.out dummy.log

#case `uname -m` in
#  i?86) GDBDIR=/usr/share/gdb/auto-load/usr/lib/   ;;
#  *)    GDBDIR=/usr/share/gdb/auto-load/usr/lib64/ ;;
#esac

#mkdir -pv $GDBDIR
#paco -p+ $TARGET "\
#mv -v /usr/lib/*gdb.py $GDBDIR" \
#	1>> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1
#unset GDBDIR

mkdir -pv /usr/share/gdb/auto-load/usr/lib
paco -p+ $TARGET "\
mv -v /usr/lib/*gdb.py /usr/share/gdb/auto-load/usr/lib" \\
	1>> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1

TimeEnd chap6

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR && rm -fr gcc-build

echo \ \ Done.

