#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

APPNAME=coreutils
VER=8.22
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Patching...
patch -Np1 -i $DLD/coreutils-$VER-i18n-4.patch \
	1>> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

echo \ \ Configuring...
FORCE_UNSAFE_CONFIGURE=1 ./configure \
            --prefix=/usr            \
            --enable-no-install-program=kill,uptime \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p  $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
mv -v /usr/bin/{cat,chgrp,chmod,chown,cp,date,dd,df,echo} /bin" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
mv -v /usr/bin/{false,ln,ls,mkdir,mknod,mv,pwd,rm} /bin" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
mv -v /usr/bin/{rmdir,stty,sync,true,uname,test,[} /bin" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
mv -v /usr/bin/chroot /usr/sbin" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
mv -v /usr/share/man/man1/chroot.1 /usr/share/man/man8/chroot.8" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
sed -i s/\"1\"/\"8\"/1 /usr/share/man/man8/chroot.8" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
mv -v /usr/bin/{head,sleep,nice} /bin" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap6

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Done.

