#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

APPNAME=vim
VER=7.4
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=vim74

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo '#define SYS_VIMRC_FILE "/etc/vimrc"' >> src/feature.h

echo \ \ Configuring...
./configure --prefix=/usr --enable-multibyte \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1

echo \ \ Installing...
paco -p $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1

paco -p+ $TARGET "ln -sv vim /usr/bin/vi"

for L in  /usr/share/man/{,*/}man1/vim.1; do
    paco -p+ $TARGET "ln -sv vim.1 $(dirname $L)/vi.1"
done

paco -p+ $TARGET "\
ln -sv ../vim/vim74/doc /usr/share/doc/vim-7.4"

cat > /etc/vimrc << "EOF"
" Begin /etc/vimrc

set nocompatible
set backspace=2
syntax on
if (&term == "iterm") || (&term == "putty")
  set background=dark
endif

" End /etc/vimrc
EOF
paco -p+ $TARGET "touch /etc/vimrc"

TimeEnd chap6

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Done.

