#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

VER=1.9.1
TARGET=inetutils-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

sed -i -e '/gets is a/d' lib/stdio.in.h

#echo Patching...
#patch -Np1 -i $DLD/inetutils-1.6-no_server_man_pages-1.patch

echo \ \ Configuring...
./configure --prefix=/usr  \
    --libexecdir=/usr/sbin \
    --localstatedir=/var   \
    --disable-ifconfig     \
    --disable-logger       \
    --disable-syslogd      \
    --disable-whois        \
    --disable-servers      \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p $TARGET "make -C doc html" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p $TARGET "make -C doc install-html docdir=/usr/share/doc/inetutils-$VER" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "mv -v /usr/bin/{hostname,ping,ping6,traceroute} /bin" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/lfstime.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

