#/bin/sh

CHAP=again2

TARGET=chroot

LFS=/mnt/lfs
SRC=$LFS/sources/LFSsystemd
DLD=$LFS/download/LFSsystemd
WRK=$LFS/work/LFScripts/LFSsystemd
LOG=$WRK/log
TME=$WRK/time

mkdir -pv $LOG $TME

mount -v --bind /dev $LFS/dev

mount -vt devpts devpts $LFS/dev/pts
mount -vt proc proc $LFS/proc
mount -vt sysfs sysfs $LFS/sys

if [ -h /dev/shm ]; then
   rm -f $LFS/dev/shm
   mkdir $LFS/dev/shm
fi

mount -vt tmpfs shm $LFS/dev/shm

chroot "$LFS" /usr/bin/env -i \
    HOME=/root TERM="$TERM" PS1='\u:\w\$ ' \
    PATH=/bin:/usr/bin:/sbin:/usr/sbin \
    /bin/bash --login

