﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text.RegularExpressions;

using Newtonsoft.Json;

using Vintagestory.API.Common;
using Vintagestory.API.Server;
using Vintagestory.Client.NoObf;

namespace AdminToolkit
{
	public static class MultiLang 
	{
		public static LanguageSet LanguageSets;
		public static string[ ] SupportedCodes { get; private set;}


		public static void Load(ILogger logger, IAssetManager ownAssetMgr, string domain)
		{
		#if DEBUG
		logger.VerboseDebug("Preparing to load Multi-Linugal data; for '{0}'", domain);
		#endif

		List<IAssetOrigin> origins = ownAssetMgr.Origins;
		LanguageSets = new LanguageSet( );
		
		GuiCompositeSettings.LanguageConfig[] supportedLangs = ownAssetMgr.Get<GuiCompositeSettings.LanguageConfig[]>(new AssetLocation("lang/languages.json"));
		SupportedCodes = supportedLangs.Select(sl => sl.Code).ToArray( );//{ "en", "de", "it", "fr",  "pt-br", "ru" };

		List<IAsset> languageAssets = ownAssetMgr.GetMany(@"lang/", domain, true);					
		foreach (var asset in languageAssets) {		
			try {			
			LanguageSets.Add(new LangEntry(asset));
			#if DEBUG
			logger.VerboseDebug("Appended M.l. Dicts: with '{0}'", asset.Name);
			#endif
		} catch (Exception e) {
			logger.Error("Failed to process multi-lang file {0}: {1}", asset.Location, e);
			}
		}
		}



		public static string Get(string langCode, string key, params object[] formaters)
		{
		if (LanguageSets.Contains(langCode)) 
		{
		LangEntry langD = LanguageSets[langCode];
		if (langD.LangEntries.ContainsKey(key)) {
		return string.Format(langD.LangEntries[key], formaters);
		}					
		}
		return key;
		}

		public static string Get(IServerPlayer byPlayerLang, string key, params object[ ] formaters)
		{
		if (LanguageSets.Contains(byPlayerLang.LanguageCode)) {
		LangEntry langD = LanguageSets[byPlayerLang.LanguageCode];
		if (langD.LangEntries.ContainsKey(key)) {
		return string.Format(langD.LangEntries[key], formaters);
		}
		}
		return key;
		}

		public static string GetUnformatted(IServerPlayer byPlayerLang, string key)
		{
		if (LanguageSets.Contains(byPlayerLang.LanguageCode)) {
		LangEntry langD = LanguageSets[byPlayerLang.LanguageCode];
		if (langD.LangEntries.ContainsKey(key)) {
		return langD.LangEntries[key];
		}
		}
		return key;
		}
	}

	public class LanguageSet : KeyedCollection<string, LangEntry>
	{
		protected override string GetKeyForItem(LangEntry item)
		{
		return item.Code;
		}
	}

	public struct LangEntry
	{
		public Dictionary<string, string> LangEntries;
		//public Dictionary<string, KeyValuePair<Regex, string>> LangRegexes;
		//public Dictionary<string, string> LangStartsWith;
		public readonly string Code;

		public LangEntry( string langCode = "en")
		{
		LangEntries = new Dictionary<string, string>( );
		//LangRegexes = new Dictionary<string, KeyValuePair<Regex, string>>( );
		//LangStartsWith = new Dictionary<string, string>( );
		Code = langCode;
		}

		public LangEntry(IAsset langAsset)
		{
		if (langAsset.IsLoaded( )) {
		LangEntries = JsonConvert.DeserializeObject<Dictionary<string, string>>(langAsset.ToText( ));
		}
		else {
		LangEntries = new Dictionary<string, string>( );
		}
		//LangRegexes = new Dictionary<string, KeyValuePair<Regex, string>>( );
		//LangStartsWith = new Dictionary<string, string>( );
		Code = langAsset.Name.Split('.').First( );
		}
	}
}

