﻿using System;
using System.Collections.ObjectModel;

using Vintagestory.API.Common;
using Vintagestory.API.MathTools;

namespace Automap
{
	/// <summary>
	/// Actual Physical Point in space - that is interesting.
	/// </summary>
	public struct PointOfInterest
	{
		//public CollectibleObject Thing;
		public string Notes;
		public BlockPos Location;
		public DateTimeOffset Timestamp;
	}

	public class PointsOfInterest : KeyedCollection<BlockPos, PointOfInterest>
	{
		protected override BlockPos GetKeyForItem(PointOfInterest item)
		{
		return item.Location;
		}

		internal void AddReplace(PointOfInterest poi)
		{
		if (this.Contains(poi.Location)) {
		this.Remove(poi.Location);
		this.Add(poi);
		}
		else {
		this.Add(poi);		
		}

		}
	}

}

