﻿using System;
using System.Collections.Generic;
using System.Drawing;

using Vintagestory.API.Client;
using Vintagestory.API.Common;
using Vintagestory.API.MathTools;
using Vintagestory.GameContent;

namespace Automap
{
	public static class DefaultDesignators
	{
		public static Designator Roads =
			 new Designator(
				new AssetLocation("game", "stonepath"),
				Color.Yellow,
				EnumBlockMaterial.Gravel
			);

		public static Designator GroundSigns =
			 new Designator(
				new AssetLocation("game", "sign-ground"),
				Color.Teal,
				EnumBlockMaterial.Wood,
				DecodeSign
			);

		public static Designator WallSigns =
			 new Designator(
				new AssetLocation("game", "sign-wall"),
				Color.Teal,
				EnumBlockMaterial.Wood,
				DecodeSign
			);

		public static Designator PostSigns =
			 new Designator(
				new AssetLocation("game", "signpost"),
				Color.Teal,
				EnumBlockMaterial.Wood,
				DecodePostSign
			);

		public static Designator Translocators =
			 new Designator(
				new AssetLocation("game", "statictranslocator-normal"),
				Color.Violet,
				EnumBlockMaterial.Metal
				//DecodeTranslocator
			);

		internal static void DecodeSign(ICoreClientAPI clientAPI, PointsOfInterest poi, BlockPos posn, Block block)
		{
		clientAPI.Logger.VerboseDebug("Sign Designator Invoked!");
		//sign Text into a POI field...
		BlockEntitySign signEntity = clientAPI.World.BlockAccessor.GetBlockEntity(posn) as BlockEntitySign;
		
		if (signEntity != null && !String.IsNullOrEmpty(signEntity.text))
		{
		
		poi.AddReplace(
					new PointOfInterest {
						Location = posn.Copy( ),
						Notes = signEntity.text,
						Timestamp = DateTimeOffset.UtcNow,
					}
					);
		
		}

		}


		internal static void DecodePostSign(ICoreClientAPI clientAPI, PointsOfInterest poi, BlockPos posn, Block block)
		{
		clientAPI.Logger.VerboseDebug("Post-sign Designator Invoked!");
		//sign post Text into a POI field...
		BlockEntitySignPost signEntity = clientAPI.World.BlockAccessor.GetBlockEntity(posn) as BlockEntitySignPost;

		if (signEntity != null && signEntity.textByCardinalDirection?.Length > 0 ) {

		poi.AddReplace(
					new PointOfInterest {
						Location = posn.Copy( ),
						Notes = string.Join(",", signEntity.textByCardinalDirection),
						Timestamp = DateTimeOffset.UtcNow,
					}
					);

		}
		}



	}
}

