#!/usr/bin/python
# -*- coding: utf-8 -*-
import sys
import shutil
import struct
import os
import argparse

# ******************************************************************
#  generate_webfont_fix.py
#  指定パスにある *.ttf ファイルから、WebFont として使う際に
#  差し支えがあるデータの修正を行います。
#  書き換えた場合はバックアップファイル *.old を生成します。
#  修正済みなどで書き換える必要がない場合は、書き換えません。
# -----------------------------------------------------------------
#  [使用方法] generate_webfont_fix.py path
#  path : 対象のディレクトリパス
# ******************************************************************

path = u'./output'

def remove_file(file_name):
	try:
		os.remove(file_name)
	except:
		pass

def process_file(file_name):
	print file_name
	infile = open(file_name, 'r')
	pos = 0

	print file_name

	for r in iter(lambda: infile.read(4), ""):
		if r == 'cmap' :
			checksumpos = infile.tell()
			checksum = struct.unpack('>I', infile.read(4))[0]
			print "checksum = %08x [%08x]" % (checksum, checksumpos)
			pos = struct.unpack('>I', infile.read(4))[0]
			break

	if pos == 0 : exit

	print "pos = %08x" % pos
	infile.seek(pos + 12)
	dat = struct.unpack('>I', infile.read(4))
	print "dat = %08x" % dat[0]
	if dat[0] == 0xa:
		infile.close()
		remove_file(file_name[:-4] + ".ttx")
		# remove_file(file_name + ".old")

		# shutil.copyfile(file_name, file_name + '.old')
		# modify cmap table
		infile = open(file_name, 'r+')
		infile.seek(pos + 12)
		infile.write(struct.pack('>I', 0x4))

		# fix checksum
		checksum -= 0xa - 0x4
		if checksum < 0:
			checksum += 0x100000000
		infile.seek(checksumpos)
		infile.write(struct.pack('>I', checksum))
		infile.close()
		print "done."

def webfont_fix(path):
	for root, dirs, files in os.walk(path):
		for file_ in files:
			if os.path.splitext(file_)[1] == u'.ttf':
				process_file(path + '/' + file_);

if __name__ == '__main__':
	parser = argparse.ArgumentParser(description='Make unicode-range from font.')
	parser.add_argument('path', nargs=1, help='path')
	args = parser.parse_args()
	path = args.path[0]

	webfont_fix(path)
