
// MainFrm.cpp : CMainFrame NX̎
//

#include "stdafx.h"
#include "FFFTP2.h"
#include "FFFTP2Doc.h"
#include "FFFTP2View.h"

#include "MainFrm.h"
extern "C" {
#include "common.h"
	}
#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWndEx)

const int  iMaxUserToolbars = 10;
const UINT uiFirstUserToolBarId = AFX_IDW_CONTROLBAR_FIRST + 40;
const UINT uiLastUserToolBarId = uiFirstUserToolBarId + iMaxUserToolbars - 1;

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWndEx)
	ON_WM_CREATE()
	ON_COMMAND(ID_WINDOW_MANAGER, &CMainFrame::OnWindowManager)
	ON_COMMAND(ID_VIEW_CUSTOMIZE, &CMainFrame::OnViewCustomize)
	ON_REGISTERED_MESSAGE(AFX_WM_CREATETOOLBAR, &CMainFrame::OnToolbarCreateNew)
	ON_COMMAND_RANGE(ID_VIEW_APPLOOK_WIN_2000, ID_VIEW_APPLOOK_WINDOWS_7, &CMainFrame::OnApplicationLook)
	ON_UPDATE_COMMAND_UI_RANGE(ID_VIEW_APPLOOK_WIN_2000, ID_VIEW_APPLOOK_WINDOWS_7, &CMainFrame::OnUpdateApplicationLook)
	ON_WM_SETTINGCHANGE()

	// menu
	ON_COMMAND(MENU_CONNECT, &CMainFrame::OnMenuConnect)
	ON_COMMAND(MENU_QUICK, &CMainFrame::OnMenuQuick)
	ON_COMMAND(MENU_DISCONNECT, &CMainFrame::OnMenuDisconnect)
	ON_COMMAND(MENU_SET_CONNECT, &CMainFrame::OnMenuSetConnect)
	ON_COMMAND(MENU_IMPORT_WS, &CMainFrame::OnMenuImportWS)
	ON_COMMAND(MENU_REGSAVE, &CMainFrame::OnMenuRegSave)
	ON_COMMAND(MENU_REGLOAD, &CMainFrame::OnMenuRegLoad)
	ON_COMMAND(MENU_CHANGEPASSWD, &CMainFrame::OnMenuChangePasswd)
	ON_COMMAND(MENU_REGINIT, &CMainFrame::OnMenuRegInit)
	ON_COMMAND(MENU_EXIT, &CMainFrame::OnMenuExit)

	ON_COMMAND(MENU_DOWNLOAD, &CMainFrame::OnMenuDownload)
	ON_COMMAND(MENU_UPLOAD, &CMainFrame::OnMenuUpload)
	ON_COMMAND(MENU_DOWNLOAD_AS, &CMainFrame::OnMenuDownloadAs)
	ON_COMMAND(MENU_UPLOAD_AS, &CMainFrame::OnMenuUploadAs)
	ON_COMMAND(MENU_DOWNLOAD_NAME, &CMainFrame::OnMenuDownloadName)
	ON_COMMAND(MENU_DOWNLOAD_AS_FILE, &CMainFrame::OnMenuDownloadAsFile)
	ON_COMMAND(MENU_MIRROR_UPLOAD, &CMainFrame::OnMenuMirrorUpload)
	ON_COMMAND(MENU_MIRROR_DOWNLOAD, &CMainFrame::OnMenuMirrorDownload)
	ON_COMMAND(MENU_DELETE, &CMainFrame::OnMenuDelete)
	ON_COMMAND(MENU_RENAME, &CMainFrame::OnMenuRename)
	ON_COMMAND(MENU_CHMOD, &CMainFrame::OnMenuChmod)
	ON_COMMAND(MENU_MKDIR, &CMainFrame::OnMenuMkdir)
	ON_COMMAND(MENU_SOMECMD, &CMainFrame::OnMenuSomeCmd)
	ON_COMMAND(MENU_SYNC, &CMainFrame::OnMenuSync)

	ON_COMMAND(MENU_BMARK_ADD, &CMainFrame::OnMenuBMarkAdd)
	ON_COMMAND(MENU_BMARK_ADD_LOCAL, &CMainFrame::OnMenuBMarkAddLocal)
	ON_COMMAND(MENU_BMARK_ADD_BOTH, &CMainFrame::OnMenuBMarkBoth)
	ON_COMMAND(MENU_BMARK_EDIT, &CMainFrame::OnMenuBMarkEdit)

	ON_COMMAND(MENU_OTPCALC, &CMainFrame::OnMenuOTPCalc)

	ON_COMMAND(MENU_OPTION, &CMainFrame::OnMenuOption)

	ON_COMMAND(MENU_HELP, &CMainFrame::OnMenuHelp)
	ON_COMMAND(MENU_HELP_TROUBLE, &CMainFrame::OnMenuHelpTrouble)
	ON_COMMAND(MENU_ABOUT, &CMainFrame::OnMenuAbout)

	// toolbar
	ON_COMMAND(MENU_DOWNLOAD, &CMainFrame::OnMenuDownload)
	ON_COMMAND(MENU_UPLOAD, &CMainFrame::OnMenuUpload)
	ON_COMMAND(MENU_MIRROR_UPLOAD, &CMainFrame::OnMenuMirrorUpload)
	ON_COMMAND(MENU_DELETE, &CMainFrame::OnMenuDelete)
	ON_COMMAND(MENU_RENAME, &CMainFrame::OnMenuRename)
	ON_COMMAND(MENU_MKDIR, &CMainFrame::OnMenuMkdir)
	ON_COMMAND(MENU_TEXT, &CMainFrame::OnMenuText)
	ON_COMMAND(MENU_BINARY, &CMainFrame::OnMenuBinary)
	ON_COMMAND(MENU_AUTO, &CMainFrame::OnMenuAuto)
	ON_COMMAND(MENU_KNJ_EUC, &CMainFrame::OnMenuKnjEuc)
	ON_COMMAND(MENU_KNJ_JIS, &CMainFrame::OnMenuKnjJis)
	ON_COMMAND(MENU_KNJ_NONE, &CMainFrame::OnMenuKnjNone)
	ON_COMMAND(MENU_KANACNV, &CMainFrame::OnMenuKanaCnv)
	ON_COMMAND(MENU_REFRESH, &CMainFrame::OnMenuRefresh)
	ON_COMMAND(MENU_LIST, &CMainFrame::OnMenuList)
	ON_COMMAND(MENU_REPORT, &CMainFrame::OnMenuReport)
	ON_COMMAND(MENU_SYNC, &CMainFrame::OnMenuSync)
	ON_COMMAND(MENU_ABORT, &CMainFrame::OnMenuAbort)

	ON_UPDATE_COMMAND_UI(MENU_TEXT, &CMainFrame::OnUpdateMenuText)
	ON_UPDATE_COMMAND_UI(MENU_BINARY, &CMainFrame::OnUpdateMenuBinary)
	ON_UPDATE_COMMAND_UI(MENU_AUTO, &CMainFrame::OnUpdateMenuAuto)
	ON_UPDATE_COMMAND_UI(MENU_KNJ_EUC, &CMainFrame::OnUpdateMenuKnjEuc)
	ON_UPDATE_COMMAND_UI(MENU_KNJ_JIS, &CMainFrame::OnUpdateMenuKnjJis)
	ON_UPDATE_COMMAND_UI(MENU_KNJ_NONE, &CMainFrame::OnUpdateMenuKnjNone)
	ON_UPDATE_COMMAND_UI(MENU_KANACNV, &CMainFrame::OnUpdateMenuKanaCnv)
	ON_UPDATE_COMMAND_UI(MENU_LIST, &CMainFrame::OnUpdateMenuList)
	ON_UPDATE_COMMAND_UI(MENU_REPORT, &CMainFrame::OnUpdateMenuReport)
	ON_UPDATE_COMMAND_UI(MENU_SYNC, &CMainFrame::OnUpdateMenuSync)



END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // Xe[^X C CWP[^[
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

// CMainFrame RXgNV/fXgNV

CMainFrame::CMainFrame()
{
	// TODO: o[R[hɒǉĂB
	theApp.m_nAppLook = theApp.GetInt(_T("ApplicationLook"), ID_VIEW_APPLOOK_VS_2008);
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIFrameWndEx::OnCreate(lpCreateStruct) == -1)
		return -1;

	BOOL bNameValid;

	CMDITabInfo mdiTabParams;
	mdiTabParams.m_style = CMFCTabCtrl::STYLE_3D_ONENOTE; // gp\Ȃ̑̎oX^C...
	mdiTabParams.m_bActiveTabCloseButton = TRUE;      // ^ü̉E [] {^zuɂ́AFALSE ɐݒ肵܂
	mdiTabParams.m_bTabIcons = FALSE;    // MDI ^uŃhLg ACRLɂɂ́ATRUE ɐݒ肵܂
	mdiTabParams.m_bAutoColor = TRUE;    // MDI ^u̎Fݒ𖳌ɂɂ́AFALSE ɐݒ肵܂
	mdiTabParams.m_bDocumentMenu = TRUE; // ^ü̉E[ɂhLg j[Lɂ܂
	EnableMDITabbedGroups(TRUE, mdiTabParams);


	if (!m_wndMenuBar.Create(this))
	{
		TRACE0("j[ o[쐬ł܂ł\n");
		return -1;      // 쐬łȂꍇ
	}

	m_wndMenuBar.SetPaneStyle(m_wndMenuBar.GetPaneStyle() | CBRS_SIZE_DYNAMIC | CBRS_TOOLTIPS | CBRS_FLYBY);

	// ANeBuɂȂƂj[ o[ɃtH[JXړȂ
	CMFCPopupMenu::SetForceMenuFocus(FALSE);

	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP | CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(theApp.m_bHiColorIcons ? IDR_MAINFRAME_256 : IDR_MAINFRAME))
	{
		TRACE0("c[ o[̍쐬Ɏs܂B\n");
		return -1;      // 쐬łȂꍇ
	}

	CString strToolBarName;
	bNameValid = strToolBarName.LoadString(IDS_TOOLBAR_STANDARD);
	ASSERT(bNameValid);
	m_wndToolBar.SetWindowText(strToolBarName);

	CString strCustomize;
	bNameValid = strCustomize.LoadString(IDS_TOOLBAR_CUSTOMIZE);
	ASSERT(bNameValid);
	m_wndToolBar.EnableCustomizeButton(TRUE, ID_VIEW_CUSTOMIZE, strCustomize);

	// [U[`̃c[ o[̑܂:
	InitUserToolbars(NULL, uiFirstUserToolBarId, uiLastUserToolBarId);

	if (!m_wndStatusBar.Create(this))
	{
		TRACE0("Xe[^X o[̍쐬Ɏs܂B\n");
		return -1;      // 쐬łȂꍇ
	}
	m_wndStatusBar.SetIndicators(indicators, sizeof(indicators)/sizeof(UINT));

	// TODO: c[ o[уj[ o[hbLO\ɂȂꍇ́A 5 ̍s폜܂
	m_wndMenuBar.EnableDocking(CBRS_ALIGN_ANY);
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockPane(&m_wndMenuBar);
	DockPane(&m_wndToolBar);


	// Visual Studio 2005 X^C̃hbLO EBhELɂ܂
	CDockingManager::SetDockingMode(DT_SMART);
	// Visual Studio 2005 X^C̃hbLO EBhE̎\Lɂ܂
	EnableAutoHidePanes(CBRS_ALIGN_ANY);

	// hbLO EBhE쐬܂
	if (!CreateDockingWindows())
	{
		TRACE0("hbLO EBhE쐬ł܂ł\n");
		return -1;
	}

	m_wndOutput.EnableDocking(CBRS_ALIGN_ANY);
	DockPane(&m_wndOutput);

	// ŒlɊÂărWA }l[W[ visual X^Cݒ肵܂
	OnApplicationLook(theApp.m_nAppLook);

	// gEBhEǗ_CAO {bNXLɂ܂
	EnableWindowsDialog(ID_WINDOW_MANAGER, ID_WINDOW_MANAGER, TRUE);

	// c[ o[ƃhbLO EBhE j[̔zuύXLɂ܂
	EnablePaneMenu(TRUE, ID_VIEW_CUSTOMIZE, strCustomize, ID_VIEW_TOOLBAR);

	// c[ o[̃NCbN (Alt L[ȂhbO) JX^}CYLɂ܂
	CMFCToolBar::EnableQuickCustomization();

	/*
	if (CMFCToolBar::GetUserImages() == NULL)
	{
		// [U[`̃c[ o[ C[Wǂݍ݂܂
		if (m_UserImages.Load(_T(".\\UserImages.bmp")))
		{
			CMFCToolBar::SetUserImages(&m_UserImages);
		}
	}
	*/

	// j[̃p[\i (ŋߎgpꂽR}h) Lɂ܂
	// TODO: [U[ŗL̊{R}h`Aej[NbNƂɊ{R}h 1 ȏ\悤ɂ܂B
	CList<UINT, UINT> lstBasicCommands;

	lstBasicCommands.AddTail(ID_FILE_NEW);
	lstBasicCommands.AddTail(ID_FILE_OPEN);
	lstBasicCommands.AddTail(ID_FILE_SAVE);
	lstBasicCommands.AddTail(ID_FILE_PRINT);
	lstBasicCommands.AddTail(ID_APP_EXIT);
	lstBasicCommands.AddTail(ID_EDIT_CUT);
	lstBasicCommands.AddTail(ID_EDIT_PASTE);
	lstBasicCommands.AddTail(ID_EDIT_UNDO);
	lstBasicCommands.AddTail(ID_APP_ABOUT);
	lstBasicCommands.AddTail(ID_VIEW_STATUS_BAR);
	lstBasicCommands.AddTail(ID_VIEW_TOOLBAR);
	lstBasicCommands.AddTail(ID_VIEW_APPLOOK_OFF_2003);
	lstBasicCommands.AddTail(ID_VIEW_APPLOOK_VS_2005);
	lstBasicCommands.AddTail(ID_VIEW_APPLOOK_OFF_2007_BLUE);
	lstBasicCommands.AddTail(ID_VIEW_APPLOOK_OFF_2007_SILVER);
	lstBasicCommands.AddTail(ID_VIEW_APPLOOK_OFF_2007_BLACK);
	lstBasicCommands.AddTail(ID_VIEW_APPLOOK_OFF_2007_AQUA);
	lstBasicCommands.AddTail(ID_VIEW_APPLOOK_WINDOWS_7);
	CMFCToolBar::SetBasicCommands(lstBasicCommands);

	// EBhE ^Cg o[ŃhLgƃAvP[V̏؂ւ܂BɂA
	//hLgkłŕ\ł邽߁A^XN o[̎gpサ܂B
	ModifyStyle(0, FWS_PREFIXTITLE);

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CMDIFrameWndEx::PreCreateWindow(cs) )
		return FALSE;
	// TODO: ̈ʒu CREATESTRUCT cs C Window NX܂̓X^C
	//  CĂB
	return TRUE;
}

BOOL CMainFrame::CreateDockingWindows()
{
	BOOL bNameValid;
	// o̓EBhE쐬܂
	CString strOutputWnd;
	bNameValid = strOutputWnd.LoadString(IDS_OUTPUT_WND);
	ASSERT(bNameValid);
	if (!m_wndOutput.Create(strOutputWnd, this, CRect(0, 0, 100, 100), TRUE, ID_VIEW_OUTPUTWND, WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | CBRS_BOTTOM | CBRS_FLOAT_MULTI))
	{
		TRACE0("o̓EBhE쐬ł܂ł\n");
		return FALSE; // 쐬ł܂ł
	}

	SetDockingWindowIcons(theApp.m_bHiColorIcons);
	return TRUE;
}

void CMainFrame::SetDockingWindowIcons(BOOL bHiColorIcons)
{
	HICON hOutputBarIcon = (HICON) ::LoadImage(::AfxGetResourceHandle(), MAKEINTRESOURCE(bHiColorIcons ? IDI_OUTPUT_WND_HC : IDI_OUTPUT_WND), IMAGE_ICON, ::GetSystemMetrics(SM_CXSMICON), ::GetSystemMetrics(SM_CYSMICON), 0);
	m_wndOutput.SetIcon(hOutputBarIcon, FALSE);

	UpdateMDITabbedBarsIcons();
}

// CMainFrame ff

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWndEx::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWndEx::Dump(dc);
}
#endif //_DEBUG


// CMainFrame bZ[W nh[

void CMainFrame::OnWindowManager()
{
	ShowWindowsDialog();
}

void CMainFrame::OnViewCustomize()
{
	CMFCToolBarsCustomizeDialog* pDlgCust = new CMFCToolBarsCustomizeDialog(this, TRUE /* j[XL܂*/);
	pDlgCust->EnableUserDefinedToolbars();
	pDlgCust->Create();
}

LRESULT CMainFrame::OnToolbarCreateNew(WPARAM wp,LPARAM lp)
{
	LRESULT lres = CMDIFrameWndEx::OnToolbarCreateNew(wp,lp);
	if (lres == 0)
	{
		return 0;
	}

	CMFCToolBar* pUserToolbar = (CMFCToolBar*)lres;
	ASSERT_VALID(pUserToolbar);

	BOOL bNameValid;
	CString strCustomize;
	bNameValid = strCustomize.LoadString(IDS_TOOLBAR_CUSTOMIZE);
	ASSERT(bNameValid);

	pUserToolbar->EnableCustomizeButton(TRUE, ID_VIEW_CUSTOMIZE, strCustomize);
	return lres;
}

void CMainFrame::OnApplicationLook(UINT id)
{
	CWaitCursor wait;

	theApp.m_nAppLook = id;

	switch (theApp.m_nAppLook)
	{
	case ID_VIEW_APPLOOK_WIN_2000:
		CMFCVisualManager::SetDefaultManager(RUNTIME_CLASS(CMFCVisualManager));
		break;

	case ID_VIEW_APPLOOK_OFF_XP:
		CMFCVisualManager::SetDefaultManager(RUNTIME_CLASS(CMFCVisualManagerOfficeXP));
		break;

	case ID_VIEW_APPLOOK_WIN_XP:
		CMFCVisualManagerWindows::m_b3DTabsXPTheme = TRUE;
		CMFCVisualManager::SetDefaultManager(RUNTIME_CLASS(CMFCVisualManagerWindows));
		break;

	case ID_VIEW_APPLOOK_OFF_2003:
		CMFCVisualManager::SetDefaultManager(RUNTIME_CLASS(CMFCVisualManagerOffice2003));
		CDockingManager::SetDockingMode(DT_SMART);
		break;

	case ID_VIEW_APPLOOK_VS_2005:
		CMFCVisualManager::SetDefaultManager(RUNTIME_CLASS(CMFCVisualManagerVS2005));
		CDockingManager::SetDockingMode(DT_SMART);
		break;

	case ID_VIEW_APPLOOK_VS_2008:
		CMFCVisualManager::SetDefaultManager(RUNTIME_CLASS(CMFCVisualManagerVS2008));
		CDockingManager::SetDockingMode(DT_SMART);
		break;

	case ID_VIEW_APPLOOK_WINDOWS_7:
		CMFCVisualManager::SetDefaultManager(RUNTIME_CLASS(CMFCVisualManagerWindows7));
		CDockingManager::SetDockingMode(DT_SMART);
		break;

	default:
		switch (theApp.m_nAppLook)
		{
		case ID_VIEW_APPLOOK_OFF_2007_BLUE:
			CMFCVisualManagerOffice2007::SetStyle(CMFCVisualManagerOffice2007::Office2007_LunaBlue);
			break;

		case ID_VIEW_APPLOOK_OFF_2007_BLACK:
			CMFCVisualManagerOffice2007::SetStyle(CMFCVisualManagerOffice2007::Office2007_ObsidianBlack);
			break;

		case ID_VIEW_APPLOOK_OFF_2007_SILVER:
			CMFCVisualManagerOffice2007::SetStyle(CMFCVisualManagerOffice2007::Office2007_Silver);
			break;

		case ID_VIEW_APPLOOK_OFF_2007_AQUA:
			CMFCVisualManagerOffice2007::SetStyle(CMFCVisualManagerOffice2007::Office2007_Aqua);
			break;
		}

		CMFCVisualManager::SetDefaultManager(RUNTIME_CLASS(CMFCVisualManagerOffice2007));
		CDockingManager::SetDockingMode(DT_SMART);
	}

	m_wndOutput.UpdateFonts();
	RedrawWindow(NULL, NULL, RDW_ALLCHILDREN | RDW_INVALIDATE | RDW_UPDATENOW | RDW_FRAME | RDW_ERASE);

	theApp.WriteInt(_T("ApplicationLook"), theApp.m_nAppLook);
}

void CMainFrame::OnUpdateApplicationLook(CCmdUI* pCmdUI)
{
	pCmdUI->SetRadio(theApp.m_nAppLook == pCmdUI->m_nID);
}


BOOL CMainFrame::LoadFrame(UINT nIDResource, DWORD dwDefaultStyle, CWnd* pParentWnd, CCreateContext* pContext) 
{
	// NXۂ̓s܂

	if (!CMDIFrameWndEx::LoadFrame(nIDResource, dwDefaultStyle, pParentWnd, pContext))
	{
		return FALSE;
	}


	// ׂẴ[U[`c[ o[̃{^̃JX^}CYLɂ܂
	BOOL bNameValid;
	CString strCustomize;
	bNameValid = strCustomize.LoadString(IDS_TOOLBAR_CUSTOMIZE);
	ASSERT(bNameValid);

	for (int i = 0; i < iMaxUserToolbars; i ++)
	{
		CMFCToolBar* pUserToolbar = GetUserToolBarByIndex(i);
		if (pUserToolbar != NULL)
		{
			pUserToolbar->EnableCustomizeButton(TRUE, ID_VIEW_CUSTOMIZE, strCustomize);
		}
	}

	return TRUE;
}


void CMainFrame::OnSettingChange(UINT uFlags, LPCTSTR lpszSection)
{
	CMDIFrameWndEx::OnSettingChange(uFlags, lpszSection);
	m_wndOutput.UpdateFonts();
}


void CMainFrame::OnUpdateFrameTitle(BOOL bAddToTitle)
{
	CFrameWnd::OnUpdateFrameTitle(FALSE);
}


/////////////////////////////////////////////////////////////////////////////
// ȉ̓j[
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// ڑj[
/////////////////////////////////////////////////////////////////////////////
/// ڑ
void CMainFrame::OnMenuConnect()
{
	auto v = (CFFFTP2View*)this->MDIGetActive()->GetActiveView();

	SetWndSocket(this->m_hWnd);
	QuickConnectProc2("raspi3.local", "pi", "masuda");
	int CancelFlg = 0;
	GetRemoteDirForWnd(CACHE_NORMAL, &CancelFlg);

}
/// NCbNڑ
void CMainFrame::OnMenuQuick()
{
}
/// ؒf
void CMainFrame::OnMenuDisconnect()
{
}
/// zXg̐ݒ
void CMainFrame::OnMenuSetConnect()
{
}
/// WS_FTPݒC|[g
void CMainFrame::OnMenuImportWS()
{
}
/// ݒt@Cɕۑ
void CMainFrame::OnMenuRegSave()
{
}
/// ݒt@C畜
void CMainFrame::OnMenuRegLoad()
{
}
/// }X^[pX[h̕ύX
void CMainFrame::OnMenuChangePasswd()
{
}
/// Sݒ̏
void CMainFrame::OnMenuRegInit()
{
}
/// I
void CMainFrame::OnMenuExit()
{
}
/////////////////////////////////////////////////////////////////////////////
// R}hj[
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnMenuDownload()
{
}
void CMainFrame::OnMenuUpload()
{
}
void CMainFrame::OnMenuDownloadAs()
{
}
void CMainFrame::OnMenuUploadAs()
{
}
void CMainFrame::OnMenuDownloadName()
{
}
void CMainFrame::OnMenuDownloadAsFile()
{
}
void CMainFrame::OnMenuMirrorUpload()
{
}
void CMainFrame::OnMenuMirrorDownload()
{
}
void CMainFrame::OnMenuDelete()
{
}
void CMainFrame::OnMenuRename()
{
}
void CMainFrame::OnMenuChmod()
{
}
void CMainFrame::OnMenuMkdir()
{
}
void CMainFrame::OnMenuSomeCmd()
{
}
void CMainFrame::OnMenuSync()
{
	m_modeMenuSync = !m_modeMenuSync;
}

/////////////////////////////////////////////////////////////////////////////
// ubN}[Nj[
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnMenuBMarkAdd()
{
}
void CMainFrame::OnMenuBMarkAddLocal()
{
}
void CMainFrame::OnMenuBMarkBoth()
{
}
void CMainFrame::OnMenuBMarkEdit()
{
}

/////////////////////////////////////////////////////////////////////////////
// \j[
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnMenuFilter()
{
}
void CMainFrame::OnMenuFind()
{
}
void CMainFrame::OnMenuFindNext()
{
}
void CMainFrame::OnMenuSelect()
{
}
void CMainFrame::OnMenuSelectAll()
{
}
void CMainFrame::OnMenuList()
{
	m_modeMenuList = true;
	m_modeMenuReport = false;
}
void CMainFrame::OnMenuReport()
{
	m_modeMenuList = false;
	m_modeMenuReport = true;
}
void CMainFrame::OnMenuSort()
{
}
void CMainFrame::OnMenuDotFile()
{
}
void CMainFrame::OnMenuDirInfo()
{
}
void CMainFrame::OnMenuTaskInfo()
{
}
void CMainFrame::OnMenuRefresh()
{
}

/////////////////////////////////////////////////////////////////////////////
// c[j[
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnMenuOTPCalc()
{
}

/////////////////////////////////////////////////////////////////////////////
// IvVj[
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnMenuOption()
{
}

/////////////////////////////////////////////////////////////////////////////
// wvj[
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnMenuHelp()
{
}
void CMainFrame::OnMenuHelpTrouble()
{
}
void CMainFrame::OnMenuAbout()
{
}

/////////////////////////////////////////////////////////////////////////////
// c[o[
/////////////////////////////////////////////////////////////////////////////

void CMainFrame::OnMenuText()
{
	m_modeMenuText = true;
	m_modeMenuBinary = false;
	m_modeMenuAuto = false;
}
void CMainFrame::OnMenuBinary()
{
	m_modeMenuText = false;
	m_modeMenuBinary = true;
	m_modeMenuAuto = false;
}
void CMainFrame::OnMenuAuto()
{
	m_modeMenuText = false;
	m_modeMenuBinary = false;
	m_modeMenuAuto = true;
}
void CMainFrame::OnMenuKnjEuc()
{
	m_modeMenuKnjEuc = true;
	m_modeMenuKnjJis = false;
	m_modeMenuKnjNone = false;
}
void CMainFrame::OnMenuKnjJis()
{
	m_modeMenuKnjEuc = false;
	m_modeMenuKnjJis = true;
	m_modeMenuKnjNone = false;
}
void CMainFrame::OnMenuKnjNone()
{
	m_modeMenuKnjEuc = false;
	m_modeMenuKnjJis = false;
	m_modeMenuKnjNone = true;
}
void CMainFrame::OnMenuKanaCnv()
{
	m_modeMenuKanaCnv = !m_modeMenuKanaCnv;
}
void CMainFrame::OnMenuAbort()
{
}


void CMainFrame::OnUpdateMenuText(CCmdUI *pCmdUI)
{
	pCmdUI->SetRadio(m_modeMenuText? 1: 0);
}
void CMainFrame::OnUpdateMenuBinary(CCmdUI *pCmdUI)
{
	pCmdUI->SetRadio(m_modeMenuBinary ? 1 : 0);
}
void CMainFrame::OnUpdateMenuAuto(CCmdUI *pCmdUI)
{
	pCmdUI->SetRadio(m_modeMenuAuto ? 1 : 0);
}

void CMainFrame::OnUpdateMenuKnjEuc(CCmdUI *pCmdUI)
{
	pCmdUI->SetRadio(m_modeMenuKnjEuc ? 1 : 0);
}
void CMainFrame::OnUpdateMenuKnjJis(CCmdUI *pCmdUI)
{
	pCmdUI->SetRadio(m_modeMenuKnjJis ? 1 : 0);
}
void CMainFrame::OnUpdateMenuKnjNone(CCmdUI *pCmdUI)
{
	pCmdUI->SetRadio(m_modeMenuKnjNone ? 1 : 0);
}
void CMainFrame::OnUpdateMenuKanaCnv(CCmdUI *pCmdUI)
{
	pCmdUI->SetRadio(m_modeMenuKanaCnv ? 1 : 0);
}
void CMainFrame::OnUpdateMenuList(CCmdUI *pCmdUI)
{
	pCmdUI->SetRadio(m_modeMenuList ? 1 : 0);
}
void CMainFrame::OnUpdateMenuReport(CCmdUI *pCmdUI)
{
	pCmdUI->SetRadio(m_modeMenuReport ? 1 : 0);
}
void CMainFrame::OnUpdateMenuSync(CCmdUI *pCmdUI)
{
	pCmdUI->SetRadio(m_modeMenuSync ? 1 : 0);
}

