/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

/**
 *
 * @author mtomono
 */
abstract public class AbstractIterator<T> implements Iterator<T> {
    T buffer;
    boolean has;
    abstract protected void findNext();

    public void nextFound(T buffered) {
        this.buffer = buffered;
        this.has = true;
    }
    
    public void prepare() {
        if (!has)
            findNext();
    }
    
    @Override
    public boolean hasNext() {
        prepare();
        return has;
    }

    @Override
    public T next() {
        prepare();
        if (!has) 
            throw new NoSuchElementException("AbstractIterator.next() : gone beyond boundary (actual class is " + this.getClass().getName() + ")");
        has = false;
        return buffer;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}
