package orderedSet;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 *
 * @author mtomono
 * @param <T>
 */
abstract public class Order<T extends Comparable<T>> {
    abstract public boolean eq(T c1, T c2);
    abstract public boolean eq(double c1, double c2);
    abstract public boolean eq(long c1, long c2);
    abstract public boolean eq(int c1, int c2);
    abstract public boolean lt(T c1, T c2);
    abstract public boolean lt(double c1, double c2);
    abstract public boolean lt(long c1, long c2);
    abstract public boolean lt(int c1, int c2);
    
    public boolean ne(T      c1, T      c2) { return !eq(c1, c2); }
    public boolean ne(double c1, double c2) { return !eq(c1, c2); }
    public boolean ne(long   c1, long   c2) { return !eq(c1, c2); }
    public boolean ne(int    c1, int    c2) { return !eq(c1, c2); }
    
    public boolean gt(T      c1, T      c2) { return  lt(c2, c1); }
    public boolean gt(double c1, double c2) { return  lt(c2, c1); }
    public boolean gt(long   c1, long   c2) { return  lt(c2, c1); }
    public boolean gt(int    c1, int    c2) { return  lt(c2, c1); }

    public boolean ge(T      c1, T      c2) { return !lt(c1, c2); }
    public boolean ge(double c1, double c2) { return !lt(c1, c2); }
    public boolean ge(long   c1, long   c2) { return !lt(c1, c2); }
    public boolean ge(int    c1, int    c2) { return !lt(c1, c2); }

    public boolean le(T      c1, T      c2) { return !gt(c1, c2); }
    public boolean le(double c1, double c2) { return !gt(c1, c2); }
    public boolean le(long   c1, long   c2) { return !gt(c1, c2); }
    public boolean le(int    c1, int    c2) { return !gt(c1, c2); }
    
    public boolean alwaysTrue(T c1, T c2) {
        return true;
    }
    
    public boolean alwaysFalse(T c1, T c2) {
        return !alwaysTrue(c1, c2);
    }
}
