/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package collection;

import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;

/**
 *
 * @author mtomono
 */
public class Dir<T> {
    Optional<Dir<T>> upper;
    List<Dir<T>> lower;
    T element;
    
    public Dir(List<Dir<T>> lower) {
        this.lower = lower;
    }
    
    public boolean isTop() {
        return !upper.isPresent();
    }
    
    public boolean isLeaf() {
        return lower.isEmpty();
    }
    
    public void add(Dir<T> lower) {
        this.lower.add(lower);
        lower.upper = Optional.of(this);
    }
    
    public void cut() {
        if (!isTop()) {
            upper.get().lower.remove(this);
            upper = Optional.empty();
        }
    }
    
    public void remove() {
        cut();
        if(!isTop())
            lower.stream().forEach(n->upper.get().add(n));
        else
            lower.stream().forEach(n->n.cut());
    }
    
    public <R> R up(R prev, BiFunction<T, R, R> func) {
        R retval = func.apply(element, prev);
        if (!isTop())
            retval = upper.get().up(retval, func);
        return retval;
    }
    
    public void down(Consumer<T> func) {
        func.accept(element);
        lower.stream().forEach(d->d.down(func));
    }
}
