/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;

import java.util.ListIterator;
import java.util.Optional;

/**
 * a listiterator which only can previous() limited times at once.
 * @author mtomono
 */
abstract public class BufferedListIterator<T> implements ListIterator<T> {
    public Optional<T> peek() {
        if (!hasNext())
            return Optional.empty();
        T retval = next();
        previous();
        return Optional.of(retval);
    }
    
    public Optional<T> pre(int i) {
        if (i > 0)
            return Optional.empty();
        T retval = previous();
        next();
        return Optional.of(retval);
    }
    
    @Override
    public int nextIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int previousIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void set(T e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void add(T e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}
