/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package orderedSet;

import java.util.List;

abstract public class Range<T extends Comparable<T>> implements Cloneable {
    @Override
    abstract public Range<T> clone();
    abstract public boolean startsAt(T value);
    abstract public boolean endsAt(T value);
    abstract public boolean isEmpty();
    abstract public boolean contains(T value);
    abstract public boolean contains(List<T> values);
    abstract public boolean contains(Range<T> another);
    abstract public boolean overlaps(List<T> values);
    abstract public boolean overlaps(Range<T> another);
    abstract public boolean hasLowerThan(T value);
    abstract public boolean hasUpperThan(T value);
    abstract public boolean startsUpperThan(Range<T> another);
    abstract public boolean endsLowerThan(Range<T> another);
    abstract public boolean isLowerThan(Range<T> another);
    abstract public boolean isUpperThan(Range<T> another);
    abstract public boolean isBelow(T value);
    abstract public boolean isAbove(T value);
    abstract public boolean isBelow(Range<T> value);
    abstract public boolean isAbove(Range<T> value);
    abstract public boolean adjoins(Range<T> another);
    abstract public boolean adjoinsAtStartWith(Range<T> another);
    abstract public boolean adjoinsAtEndWith(Range<T> another);
    abstract public Range<T> intersect(Range<T> another);
    abstract public Range<T> cover(T value);
    abstract public Range<T> cover(Range<T> another);
    abstract public Range<T> getLower(T value);
    abstract public Range<T> getUpper(T value);
    abstract public Range<T> getLowerRoomIn(Range<T> another);
    abstract public Range<T> getUpperRoomIn(Range<T> another);
    abstract public T start();
    abstract public T end();
}
