/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package parser;

import grammar.Nod;
import context.IContext;
import java.util.Optional;
import java.util.function.Predicate;
import static org.testng.Assert.*;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import static grammar.Convenients.eq;
import static parser.Fixture.a;
import static parser.Fixture.o;
import static parser.Fixture.testList1;
import view.View;
import view.ViewList;

/**
 *
 * @author mtomono
 */
public class MNod {

    
    public MNod() {
    }
    
    @Test
    public void nod_success() {
        IContext<String> c = new IContext(ViewList.reverse(View.pre(testList1, 2)));
        assertTrue(ParseAndStay.matches(new Nod<>(eq("test0")), c));
    }

    @Test
    public void nod_success_get() {
        IContext<String> c = new IContext(ViewList.reverse(View.pre(testList1, 2)));
        assertEquals(new SimpleParser<>(new Nod<>(eq("test0"))).parse(c).get(0), a(o("test0")));
    }

    @Test
    public void nod_fail() {
        IContext<String> c = new IContext(ViewList.reverse(View.pre(testList1, 2)));
        assertFalse(ParseAndStay.matches(new Nod<>(eq("test1")), c));
    }
}
