/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package parser;

import context.IContext;
import static grammar.Convenients.eq;
import grammar.Grammar;
import static grammar.Grammar.*;
import grammar.Nod;
import grammar.Rep;
import grammar.Seq;
import orderedSet.Between;
import static org.testng.Assert.*;
import org.testng.annotations.Test;
import static parser.Fixture.*;

/**
 *
 * @author mtomono
 */
public class MReduceRange {
    
    public MReduceRange() {
    }
    
    String test0 = "test0";
    String test1 = "test1";
    
    @Test
    public void range1() {
        IContext<String> c = IContext.c(testList2, 2);
        Grammar<String> g = 
                new Rep<>(
                        new Seq<>(
                                new Nod<>(eq(test1)), 
                                new Nod<>(eq(test0))
                        ), 
                1, 3).with(RangeTree);
        assertEquals(new EasyParser<String>(g).parse(c).get(0), new Between(1, 3));
    }

    @Test
    public void range2() {
        IContext<String> c = IContext.c(testList4, 2);
        Grammar<String> g = 
                new Rep<>(
                        new Seq<>(
                                new Nod<>(eq(test1)), 
                                new Nod<>(eq(test0))
                        ), 
                1, 3).with(RangeTree);
        assertEquals(new EasyParser<String>(g).parse(c).get(0), new Between(1, 5));
    }

    @Test
    public void range3() {
        IContext<String> c = IContext.c(testList4, 2);
        Grammar<String> g = 
                new Seq<>(
                        new Nod<>(eq(test1)), 
                        new Nod<>(eq(test0))
                ).with(RangeTree);
        assertEquals(new EasyParser<String>(g).parse(c).get(0), new Between(1, 3));
    }

    @Test
    public void range4() {
        IContext<String> c = IContext.c(testList4, 2);
        Grammar<String> g = 
                new Rep<>(
                        new Seq<>(
                                new Nod<>(eq(test0)), 
                                new Nod<>(eq(test1))
                        ),1,10).with(RangeTree);
        assertEquals(new EasyParser<String>(g).parse(c).get(0), new Between(0, 6));
    }


}
