/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package orderedSet;

import iterator.AbstractIterator;
import java.util.Iterator;
import static arithmetic.Arithmetic.*;

/**
 *
 * @author mtomono
 * @param <T>
 */
public class CoverRangeIterator<T extends Number & Comparable<T>> extends AbstractIterator<Between<T>> {
    T unit;
    T base;
    Iterator<T> iter;
    boolean ready;
    T start;
    T end;
    
    final boolean checkBase() {
        this.iter = new AssertOrderListIterator<T>(this.iter) {
            @Override
            public boolean inOrder(T pre, T now) {
                return lt.o(pre, now);
            }
        };
        return true;
    }
    
    public CoverRangeIterator(Iterator<T> iter, T base, T unit) {
        this.base = base;
        this.unit = unit;
        this.iter = iter;
        assert checkBase();
        this.ready = false;
        if (iter.hasNext()) {
            this.ready = true;
            this.start = floor(iter.next());
            this.end = (T)add.o(start, unit);
        }
    }
    
    final T ceil(Number target) {
        return (T)mul.o(ceilx.o(div.o(sub.o(target, base), unit)), unit);
    }
    
    final T floor(Number target) {
        return (T)mul.o(floor.o(div.o(sub.o(target, base), unit)), unit);
    }
    
    @Override
    protected void findNext() {
        if (!ready)
            return;
        T one = null;
        while (true) {
            if (!iter.hasNext()) {
                ready = false;
                break;
            }
            one = iter.next();
            if (ge.o(one, add.o(end, unit)))
                break;
            end = (T)ceil(one);
        }
        nextFound(new Between<>(start, end));
        if (one != null) {
            start = floor(one);
            end = (T)add.o(start, unit);
        }
    }
}
