/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package orderedSet;

import collection.c;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import static org.testng.Assert.*;
import org.testng.annotations.BeforeClass;

/**
 *
 * @author mtomono
 */
public class ExtensiveSetTest {
    
    public ExtensiveSetTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Test
    public void testContains_GenericType() {
        ExtensiveSet<Integer> target = new ExtensiveSet<>(2, 4, 6, 8, 10);
        assertTrue(target.contains(2));
        assertTrue(target.contains(4));
        assertTrue(target.contains(6));
        assertTrue(target.contains(8));
        assertTrue(target.contains(10));
        assertFalse(target.contains(1));
        assertFalse(target.contains(3));
        assertFalse(target.contains(5));
        assertFalse(target.contains(7));
        assertFalse(target.contains(9));
        assertFalse(target.contains(11));
    }

   @Test
    public void testContains_List() {
        ExtensiveSet<Integer> target = new ExtensiveSet<>(2, 4, 6, 8, 10);
        assertTrue(target.contains(c.a2l(2, 4, 6)));
        assertTrue(target.contains(c.a2l(6, 8, 10)));
        assertTrue(target.contains(c.a2l(2, 4, 8, 10)));
        assertTrue(target.contains(c.a2l(2, 10)));
        assertTrue(target.contains(c.a2l(4, 10)));
        assertTrue(target.contains(c.a2l(2, 8)));
        assertTrue(target.contains(c.a2l(4, 8)));
        assertFalse(target.contains(c.a2l(1, 2, 4, 6)));
        assertFalse(target.contains(c.a2l(2, 3, 4, 6)));
        assertFalse(target.contains(c.a2l(2, 4, 5, 6)));
        assertFalse(target.contains(c.a2l(2, 4, 6, 7)));
        assertFalse(target.contains(c.a2l(2, 4, 6, 11)));
        assertFalse(target.contains(c.a2l(1, 6, 8, 10)));
        assertFalse(target.contains(c.a2l(5, 6, 8, 10)));
        assertFalse(target.contains(c.a2l(6, 7, 8, 10)));
        assertFalse(target.contains(c.a2l(6, 8, 9, 10)));
        assertFalse(target.contains(c.a2l(6, 8, 10, 11)));
        assertFalse(target.contains(c.a2l(1, 2, 4, 8, 10)));
        assertFalse(target.contains(c.a2l(2, 3, 4, 8, 10)));
        assertFalse(target.contains(c.a2l(2, 4, 5, 8, 10)));
        assertFalse(target.contains(c.a2l(2, 4, 8, 9, 10)));
        assertFalse(target.contains(c.a2l(2, 4, 8, 10, 11)));
        assertFalse(target.contains(c.a2l(1, 2, 10)));
        assertFalse(target.contains(c.a2l(2, 3, 10)));
        assertFalse(target.contains(c.a2l(2, 5, 10)));
        assertFalse(target.contains(c.a2l(2, 7, 10)));
        assertFalse(target.contains(c.a2l(2, 9, 10)));
        assertFalse(target.contains(c.a2l(2, 10, 11)));
        assertFalse(target.contains(c.a2l(1, 4, 10)));
        assertFalse(target.contains(c.a2l(3, 4, 10)));
        assertFalse(target.contains(c.a2l(4, 5, 10)));
        assertFalse(target.contains(c.a2l(4, 7, 10)));
        assertFalse(target.contains(c.a2l(4, 9, 10)));
        assertFalse(target.contains(c.a2l(4, 10, 11)));
        assertFalse(target.contains(c.a2l(1, 2, 8)));
        assertFalse(target.contains(c.a2l(2, 3, 8)));
        assertFalse(target.contains(c.a2l(2, 5, 8)));
        assertFalse(target.contains(c.a2l(2, 7, 8)));
        assertFalse(target.contains(c.a2l(2, 8, 9)));
        assertFalse(target.contains(c.a2l(2, 8, 11)));
        assertFalse(target.contains(c.a2l(1, 4, 8)));
        assertFalse(target.contains(c.a2l(3, 4, 8)));
        assertFalse(target.contains(c.a2l(4, 5, 8)));
        assertFalse(target.contains(c.a2l(4, 7, 8)));
        assertFalse(target.contains(c.a2l(4, 8, 9)));
        assertFalse(target.contains(c.a2l(4, 8, 11)));
        assertFalse(target.contains(c.a2l(1, 3, 5, 7, 9, 11)));
        assertFalse(target.contains(c.a2l(3, 5, 7, 9, 11)));
        assertFalse(target.contains(c.a2l(5, 7, 9, 11)));
        assertFalse(target.contains(c.a2l(7, 9, 11)));
        assertFalse(target.contains(c.a2l(9, 11)));
        assertFalse(target.contains(c.a2l(11)));
    }

    @Test
    public void testOverlaps() {
        ExtensiveSet<Integer> target = new ExtensiveSet<>(2, 4, 6, 8, 10);
        assertTrue(target.overlaps(c.a2l(2, 4, 6)));
        assertTrue(target.overlaps(c.a2l(6, 8, 10)));
        assertTrue(target.overlaps(c.a2l(2, 4, 8, 10)));
        assertTrue(target.overlaps(c.a2l(2, 10)));
        assertTrue(target.overlaps(c.a2l(4, 10)));
        assertTrue(target.overlaps(c.a2l(2, 8)));
        assertTrue(target.overlaps(c.a2l(4, 8)));
        assertTrue(target.overlaps(c.a2l(1, 2, 4, 6)));
        assertTrue(target.overlaps(c.a2l(2, 3, 4, 6)));
        assertTrue(target.overlaps(c.a2l(2, 4, 5, 6)));
        assertTrue(target.overlaps(c.a2l(2, 4, 6, 7)));
        assertTrue(target.overlaps(c.a2l(2, 4, 6, 11)));
        assertTrue(target.overlaps(c.a2l(1, 6, 8, 10)));
        assertTrue(target.overlaps(c.a2l(5, 6, 8, 10)));
        assertTrue(target.overlaps(c.a2l(6, 7, 8, 10)));
        assertTrue(target.overlaps(c.a2l(6, 8, 9, 10)));
        assertTrue(target.overlaps(c.a2l(6, 8, 10, 11)));
        assertTrue(target.overlaps(c.a2l(1, 2, 4, 8, 10)));
        assertTrue(target.overlaps(c.a2l(2, 3, 4, 8, 10)));
        assertTrue(target.overlaps(c.a2l(2, 4, 5, 8, 10)));
        assertTrue(target.overlaps(c.a2l(2, 4, 8, 9, 10)));
        assertTrue(target.overlaps(c.a2l(2, 4, 8, 10, 11)));
        assertTrue(target.overlaps(c.a2l(1, 2, 10)));
        assertTrue(target.overlaps(c.a2l(2, 3, 10)));
        assertTrue(target.overlaps(c.a2l(2, 5, 10)));
        assertTrue(target.overlaps(c.a2l(2, 7, 10)));
        assertTrue(target.overlaps(c.a2l(2, 9, 10)));
        assertTrue(target.overlaps(c.a2l(2, 10, 11)));
        assertTrue(target.overlaps(c.a2l(1, 4, 10)));
        assertTrue(target.overlaps(c.a2l(3, 4, 10)));
        assertTrue(target.overlaps(c.a2l(4, 5, 10)));
        assertTrue(target.overlaps(c.a2l(4, 7, 10)));
        assertTrue(target.overlaps(c.a2l(4, 9, 10)));
        assertTrue(target.overlaps(c.a2l(4, 10, 11)));
        assertTrue(target.overlaps(c.a2l(1, 2, 8)));
        assertTrue(target.overlaps(c.a2l(2, 3, 8)));
        assertTrue(target.overlaps(c.a2l(2, 5, 8)));
        assertTrue(target.overlaps(c.a2l(2, 7, 8)));
        assertTrue(target.overlaps(c.a2l(2, 8, 9)));
        assertTrue(target.overlaps(c.a2l(2, 8, 11)));
        assertTrue(target.overlaps(c.a2l(1, 4, 8)));
        assertTrue(target.overlaps(c.a2l(3, 4, 8)));
        assertTrue(target.overlaps(c.a2l(4, 5, 8)));
        assertTrue(target.overlaps(c.a2l(4, 7, 8)));
        assertTrue(target.overlaps(c.a2l(4, 8, 9)));
        assertTrue(target.overlaps(c.a2l(4, 8, 11)));
        assertTrue(target.overlaps(c.a2l(1, 2, 3, 5, 7, 9, 11)));
        assertTrue(target.overlaps(c.a2l(1, 3, 4, 5, 7, 9, 11)));
        assertTrue(target.overlaps(c.a2l(1, 3, 5, 6, 7, 9, 11)));
        assertTrue(target.overlaps(c.a2l(1, 3, 5, 7, 8, 9, 11)));
        assertTrue(target.overlaps(c.a2l(1, 3, 5, 7, 9, 10, 11)));
        assertFalse(target.overlaps(c.a2l(1, 3, 5, 7, 9, 11)));
        assertFalse(target.overlaps(c.a2l(3, 5, 7, 9, 11)));
        assertFalse(target.overlaps(c.a2l(5, 7, 9, 11)));
        assertFalse(target.overlaps(c.a2l(7, 9, 11)));
        assertFalse(target.overlaps(c.a2l(9, 11)));
        assertFalse(target.overlaps(c.a2l(11)));
    }

    @Test
    public void testIntersect() {
        ExtensiveSet<Integer> target = new ExtensiveSet<>(2, 4, 6, 8, 10);
        assertEquals(c.a2l(2, 4, 6), target.intersect(c.a2l(2, 4, 6)));
        assertEquals(c.a2l(6, 8, 10), target.intersect(c.a2l(6, 8, 10)));
        assertEquals(c.a2l(2, 4, 8, 10), target.intersect(c.a2l(2, 4, 8, 10)));
        assertEquals(c.a2l(2, 10), target.intersect(c.a2l(2, 10)));
        assertEquals(c.a2l(4, 10), target.intersect(c.a2l(4, 10)));
        assertEquals(c.a2l(2, 8), target.intersect(c.a2l(2, 8)));
        assertEquals(c.a2l(4, 8), target.intersect(c.a2l(4, 8)));
        assertEquals(c.a2l(2, 4, 6), target.intersect(c.a2l(1, 2, 4, 6)));
        assertEquals(c.a2l(2, 4, 6), target.intersect(c.a2l(2, 3, 4, 6)));
        assertEquals(c.a2l(2, 4, 6), target.intersect(c.a2l(2, 4, 5, 6)));
        assertEquals(c.a2l(2, 4, 6), target.intersect(c.a2l(2, 4, 6, 7)));
        assertEquals(c.a2l(2, 4, 6), target.intersect(c.a2l(2, 4, 6, 11)));
        assertEquals(c.a2l(6, 8, 10), target.intersect(c.a2l(1, 6, 8, 10)));
        assertEquals(c.a2l(6, 8, 10), target.intersect(c.a2l(5, 6, 8, 10)));
        assertEquals(c.a2l(6, 8, 10), target.intersect(c.a2l(6, 7, 8, 10)));
        assertEquals(c.a2l(6, 8, 10), target.intersect(c.a2l(6, 8, 9, 10)));
        assertEquals(c.a2l(6, 8, 10), target.intersect(c.a2l(6, 8, 10, 11)));
        assertEquals(c.a2l(2, 4, 8, 10), target.intersect(c.a2l(1, 2, 4, 8, 10)));
        assertEquals(c.a2l(2, 4, 8, 10), target.intersect(c.a2l(2, 3, 4, 8, 10)));
        assertEquals(c.a2l(2, 4, 8, 10), target.intersect(c.a2l(2, 4, 5, 8, 10)));
        assertEquals(c.a2l(2, 4, 8, 10), target.intersect(c.a2l(2, 4, 8, 9, 10)));
        assertEquals(c.a2l(2, 4, 8, 10), target.intersect(c.a2l(2, 4, 8, 10, 11)));
        assertEquals(c.a2l(2, 10), target.intersect(c.a2l(1, 2, 10)));
        assertEquals(c.a2l(2, 10), target.intersect(c.a2l(2, 3, 10)));
        assertEquals(c.a2l(2, 10), target.intersect(c.a2l(2, 5, 10)));
        assertEquals(c.a2l(2, 10), target.intersect(c.a2l(2, 7, 10)));
        assertEquals(c.a2l(2, 10), target.intersect(c.a2l(2, 9, 10)));
        assertEquals(c.a2l(2, 10), target.intersect(c.a2l(2, 10, 11)));
        assertEquals(c.a2l(4, 10), target.intersect(c.a2l(1, 4, 10)));
        assertEquals(c.a2l(4, 10), target.intersect(c.a2l(3, 4, 10)));
        assertEquals(c.a2l(4, 10), target.intersect(c.a2l(4, 5, 10)));
        assertEquals(c.a2l(4, 10), target.intersect(c.a2l(4, 7, 10)));
        assertEquals(c.a2l(4, 10), target.intersect(c.a2l(4, 9, 10)));
        assertEquals(c.a2l(4, 10), target.intersect(c.a2l(4, 10, 11)));
        assertEquals(c.a2l(2, 8), target.intersect(c.a2l(1, 2, 8)));
        assertEquals(c.a2l(2, 8), target.intersect(c.a2l(2, 3, 8)));
        assertEquals(c.a2l(2, 8), target.intersect(c.a2l(2, 5, 8)));
        assertEquals(c.a2l(2, 8), target.intersect(c.a2l(2, 7, 8)));
        assertEquals(c.a2l(2, 8), target.intersect(c.a2l(2, 8, 9)));
        assertEquals(c.a2l(2, 8), target.intersect(c.a2l(2, 8, 11)));
        assertEquals(c.a2l(4, 8), target.intersect(c.a2l(1, 4, 8)));
        assertEquals(c.a2l(4, 8), target.intersect(c.a2l(3, 4, 8)));
        assertEquals(c.a2l(4, 8), target.intersect(c.a2l(4, 5, 8)));
        assertEquals(c.a2l(4, 8), target.intersect(c.a2l(4, 7, 8)));
        assertEquals(c.a2l(4, 8), target.intersect(c.a2l(4, 8, 9)));
        assertEquals(c.a2l(4, 8), target.intersect(c.a2l(4, 8, 11)));
        assertEquals(c.a2l(2), target.intersect(c.a2l(1, 2, 3, 5, 7, 9, 11)));
        assertEquals(c.a2l(4), target.intersect(c.a2l(1, 3, 4, 5, 7, 9, 11)));
        assertEquals(c.a2l(6), target.intersect(c.a2l(1, 3, 5, 6, 7, 9, 11)));
        assertEquals(c.a2l(8), target.intersect(c.a2l(1, 3, 5, 7, 8, 9, 11)));
        assertEquals(c.a2l(10), target.intersect(c.a2l(1, 3, 5, 7, 9, 10, 11)));
        assertTrue(target.intersect(c.a2l(1, 3, 5, 7, 9, 11)).isEmpty());
        assertTrue(target.intersect(c.a2l(3, 5, 7, 9, 11)).isEmpty());
        assertTrue(target.intersect(c.a2l(5, 7, 9, 11)).isEmpty());
        assertTrue(target.intersect(c.a2l(7, 9, 11)).isEmpty());
        assertTrue(target.intersect(c.a2l(9, 11)).isEmpty());
        assertTrue(target.intersect(c.a2l(11)).isEmpty());
    }

    @Test
    public void testMask() {
        ExtensiveSet<Integer> target = new ExtensiveSet<>(2, 4, 6, 8, 10);
        assertEquals(c.a2l(), target.mask(c.a2l(2, 4, 6)));
        assertEquals(c.a2l(), target.mask(c.a2l(6, 8, 10)));
        assertEquals(c.a2l(), target.mask(c.a2l(2, 4, 8, 10)));
        assertEquals(c.a2l(), target.mask(c.a2l(2, 10)));
        assertEquals(c.a2l(), target.mask(c.a2l(4, 10)));
        assertEquals(c.a2l(), target.mask(c.a2l(2, 8)));
        assertEquals(c.a2l(), target.mask(c.a2l(4, 8)));
        assertEquals(c.a2l(1), target.mask(c.a2l(1, 2, 4, 6)));
        assertEquals(c.a2l(3), target.mask(c.a2l(2, 3, 4, 6)));
        assertEquals(c.a2l(5), target.mask(c.a2l(2, 4, 5, 6)));
        assertEquals(c.a2l(7), target.mask(c.a2l(2, 4, 6, 7)));
        assertEquals(c.a2l(11), target.mask(c.a2l(2, 4, 6, 11)));
        assertEquals(c.a2l(1), target.mask(c.a2l(1, 6, 8, 10)));
        assertEquals(c.a2l(5), target.mask(c.a2l(5, 6, 8, 10)));
        assertEquals(c.a2l(7), target.mask(c.a2l(6, 7, 8, 10)));
        assertEquals(c.a2l(9), target.mask(c.a2l(6, 8, 9, 10)));
        assertEquals(c.a2l(11), target.mask(c.a2l(6, 8, 10, 11)));
        assertEquals(c.a2l(1), target.mask(c.a2l(1, 2, 4, 8, 10)));
        assertEquals(c.a2l(3), target.mask(c.a2l(2, 3, 4, 8, 10)));
        assertEquals(c.a2l(5), target.mask(c.a2l(2, 4, 5, 8, 10)));
        assertEquals(c.a2l(9), target.mask(c.a2l(2, 4, 8, 9, 10)));
        assertEquals(c.a2l(11), target.mask(c.a2l(2, 4, 8, 10, 11)));
        assertEquals(c.a2l(1), target.mask(c.a2l(1, 2, 10)));
        assertEquals(c.a2l(3), target.mask(c.a2l(2, 3, 10)));
        assertEquals(c.a2l(5), target.mask(c.a2l(2, 5, 10)));
        assertEquals(c.a2l(7), target.mask(c.a2l(2, 7, 10)));
        assertEquals(c.a2l(9), target.mask(c.a2l(2, 9, 10)));
        assertEquals(c.a2l(11), target.mask(c.a2l(2, 10, 11)));
        assertEquals(c.a2l(1), target.mask(c.a2l(1, 4, 10)));
        assertEquals(c.a2l(3), target.mask(c.a2l(3, 4, 10)));
        assertEquals(c.a2l(5), target.mask(c.a2l(4, 5, 10)));
        assertEquals(c.a2l(7), target.mask(c.a2l(4, 7, 10)));
        assertEquals(c.a2l(9), target.mask(c.a2l(4, 9, 10)));
        assertEquals(c.a2l(11), target.mask(c.a2l(4, 10, 11)));
        assertEquals(c.a2l(1), target.mask(c.a2l(1, 2, 8)));
        assertEquals(c.a2l(3), target.mask(c.a2l(2, 3, 8)));
        assertEquals(c.a2l(5), target.mask(c.a2l(2, 5, 8)));
        assertEquals(c.a2l(7), target.mask(c.a2l(2, 7, 8)));
        assertEquals(c.a2l(9), target.mask(c.a2l(2, 8, 9)));
        assertEquals(c.a2l(11), target.mask(c.a2l(2, 8, 11)));
        assertEquals(c.a2l(1), target.mask(c.a2l(1, 4, 8)));
        assertEquals(c.a2l(3), target.mask(c.a2l(3, 4, 8)));
        assertEquals(c.a2l(5), target.mask(c.a2l(4, 5, 8)));
        assertEquals(c.a2l(7), target.mask(c.a2l(4, 7, 8)));
        assertEquals(c.a2l(9), target.mask(c.a2l(4, 8, 9)));
        assertEquals(c.a2l(11), target.mask(c.a2l(4, 8, 11)));
        assertEquals(c.a2l(1, 3, 5, 7, 9, 11), target.mask(c.a2l(1, 2, 3, 5, 7, 9, 11)));
        assertEquals(c.a2l(1, 3, 5, 7, 9, 11), target.mask(c.a2l(1, 3, 4, 5, 7, 9, 11)));
        assertEquals(c.a2l(1, 3, 5, 7, 9, 11), target.mask(c.a2l(1, 3, 5, 6, 7, 9, 11)));
        assertEquals(c.a2l(1, 3, 5, 7, 9, 11), target.mask(c.a2l(1, 3, 5, 7, 8, 9, 11)));
        assertEquals(c.a2l(1, 3, 5, 7, 9, 11), target.mask(c.a2l(1, 3, 5, 7, 9, 10, 11)));
        assertEquals(c.a2l(3, 5, 7, 9), target.mask(c.a2l(2, 3, 5, 7, 9)));
        assertEquals(c.a2l(3, 5, 7, 9), target.mask(c.a2l(3, 5, 7, 9, 10)));
        assertEquals(c.a2l(1, 3, 5, 7, 9, 11), target.mask(c.a2l(1, 3, 5, 7, 9, 11)));
        assertEquals(c.a2l(3, 5, 7, 9, 11), target.mask(c.a2l(3, 5, 7, 9, 11)));
        assertEquals(c.a2l(5, 7, 9, 11), target.mask(c.a2l(5, 7, 9, 11)));
        assertEquals(c.a2l(7, 9, 11), target.mask(c.a2l(7, 9, 11)));
        assertEquals(c.a2l(9, 11), target.mask(c.a2l(9, 11)));
        assertEquals(c.a2l(11), target.mask(c.a2l(11)));
    }
}
