/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package parser;

import grammar.Nod;
import grammar.Seq;
import context.IContext;
import static org.testng.Assert.*;
import org.testng.annotations.Test;
import static grammar.Convenients.*;
import grammar.END;
import grammar.START;
import static parser.Fixture.*;
import view.View;
import view.ViewList;

/**
 *
 * @author mtomono
 */
public class MEND {
    
    public MEND() {
    }
    
    String test0 = "test0";
    String test1 = "test1";

    @Test
    public void end_success() {
        IContext<String> c = new IContext(ViewList.reverse(View.pre(testList2, 2)));
        assertTrue(ParseAndStay.matches(
                new Seq<>(
                        new START<>(),
                        new Nod<>(eq(test0)), 
                        new Nod<>(eq(test1)), 
                        new Nod<>(eq(test0)), 
                        new Nod<>(eq(test1)), 
                        new END<>()),
                c));
    }
    
    @Test
    public void end_fail() {
        IContext<String> c = new IContext(ViewList.reverse(View.pre(testList2, 2)));
        assertFalse(ParseAndStay.matches(
                new Seq<>(
                        new Nod<>(eq(test0)), 
                        new Nod<>(eq(test1)), 
                        new Nod<>(eq(test0)), 
                        new END<>()),
                c));
    }
}
