/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package parser;

import context.IContext;
import grammar.Grammar;
import java.util.function.Function;
import java.util.function.ToIntFunction;

/**
 *
 * @author mtomono
 */
public class ParseFunction<T, OUT> {
    
    public static <T, R> Function<IContext<T>, R> parseBody(Grammar<T> body) {
        return target-> {
            target.stack().push(new ParseResult());
            ParseAndStay.matches(body, target);
            return (R)target.stack().pop().get(0);
        };
    }
    
    public static <T> ToIntFunction<IContext<T>> parseLength(Grammar<T> body) {
        return target->ParseAndStay.length(body, target);
    }
}
