/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package orderedSet;

import static org.testng.Assert.assertEquals;
import org.testng.annotations.Test;

/**
 *
 * @author mtomono
 */
public class IntegerRangeTest {
    Order<Integer> order;
    
    public IntegerRangeTest() {
        this.order = new NaturalOrder();
    }

    /**
     * Test of clone method, of class Fragment.
     */
    @Test
    public void testClone() {
        Between<Integer> original = new Between<>(-12, 2, order);
        Between<Integer> tested = (Between<Integer>)original.clone();
        assertEquals(original.getStart(), tested.getStart());
        assertEquals(original.getEnd(), tested.getEnd());
    }
    
    @Test
    public void testEquals() {
        class x {
            Range<Integer> tested = new Between<>(-12, 2, order);
            boolean test(Range<Integer> f) {
                return tested.equals(f);
            }
        }
        assertEquals(false, new x().test(new Between<>(-36, -14, order))); //-   - |     |
        assertEquals(false, new x().test(new Between<>(-36, -13, order))); //-    -|     |
        assertEquals(false, new x().test(new Between<>(-36, -12, order))); //-     +     |
        assertEquals(false, new x().test(new Between<>(-36, -11, order))); //-     |-    |
        assertEquals(false, new x().test(new Between<>(-36, -10, order))); //-     | -   |
        assertEquals(false, new x().test(new Between<>(-36,   0, order))); //-     |   - |
        assertEquals(false, new x().test(new Between<>(-36,   1, order))); //-     |    -|
        assertEquals(false, new x().test(new Between<>(-36,   2, order))); //-     |     +
        assertEquals(false, new x().test(new Between<>(-36,   3, order))); //-     |     |-
        assertEquals(false, new x().test(new Between<>(-36,   4, order))); //-     |     | -
        assertEquals(false, new x().test(new Between<>(-14,  24, order))); //    - |     |    -
        assertEquals(false, new x().test(new Between<>(-13,  24, order))); //     -|     |    -
        assertEquals(false, new x().test(new Between<>(-12,  24, order))); //      +     |    -
        assertEquals(false, new x().test(new Between<>(-11,  24, order))); //      |-    |    -
        assertEquals(false, new x().test(new Between<>(-10,  24, order))); //      | -   |    -
        assertEquals(false, new x().test(new Between<>(  0,  24, order))); //      |   - |    -
        assertEquals(false, new x().test(new Between<>(  1,  24, order))); //      |    -|    -
        assertEquals(false, new x().test(new Between<>(  2,  24, order))); //      |     +    -
        assertEquals(false, new x().test(new Between<>(  3,  24, order))); //      |     |-   -
        assertEquals(false, new x().test(new Between<>(  4,  24, order))); //      |     | -  -
        assertEquals(false, new x().test(new Between<>(-14,   0, order))); //    - |   - |
        assertEquals(false, new x().test(new Between<>(-13,   0, order))); //     -|   - |
        assertEquals(false, new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(false, new x().test(new Between<>(-11,   0, order))); //      |-  - |
        assertEquals(false, new x().test(new Between<>(-10,   0, order))); //      | - - |
        assertEquals(false, new x().test(new Between<>(-10,   1, order))); //      | -  -|
        assertEquals(false, new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(false, new x().test(new Between<>(-10,   3, order))); //      | -   |-
        assertEquals(false, new x().test(new Between<>(-10,   4, order))); //      | -   | -
        assertEquals(false, new x().test(new Between<>(-14,   2, order))); //    - |     +
        assertEquals(false, new x().test(new Between<>(-13,   2, order))); //     -|     +
        assertEquals(true , new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(false, new x().test(new Between<>(-11,   2, order))); //      |-    +
        assertEquals(false, new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(false, new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(false, new x().test(new Between<>(-12,   1, order))); //      +    -|
        assertEquals(true , new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(false, new x().test(new Between<>(-12,   3, order))); //      +     |-
        assertEquals(false, new x().test(new Between<>(-12,   4, order))); //      +     | -
    }
    
    /**
     * Test of getStart method, of class Fragment.
     */
    @Test
    public void testGetStart() {
        Between<Integer> tested = new Between<>(-12, 2, order);
        assertEquals(Integer.valueOf(-12), tested.getStart());
    }

    /**
     * Test of getEnd method, of class Fragment.
     */
    @Test
    public void testGetEnd() {
        Between<Integer> tested = new Between<>(-12, 2, order);
        assertEquals(Integer.valueOf(2), tested.getEnd());
    }

    /**
     * Test of contains method, of class Fragment.
     */
    @Test
    public void testContains_GenericType() {
        class y {
            Range<Integer> tested = new Between<>(-12, 2, order);
            boolean test(int f) {
                return tested.contains(f);
            }
        }
        assertEquals(false, new y().test(-14));
        assertEquals(false, new y().test(-13));
        assertEquals(true , new y().test(-12));
        assertEquals(true , new y().test(-11));
        assertEquals(true , new y().test(-10));
        assertEquals(true , new y().test(0));
        assertEquals(true , new y().test(1));
        assertEquals(false, new y().test(2));
        assertEquals(false, new y().test(3));
        assertEquals(false, new y().test(4));
    }

    /**
     * Test of isAbove method, of class Fragment.
     */
    @Test
    public void testIsAbove_GenericType() {
        class y {
            Range<Integer> tested = new Between<>(-12, 2, order);
            boolean test(int f) {
                return tested.isAbove(f);
            }
        }
        assertEquals(true , new y().test(-14));
        assertEquals(true , new y().test(-13));
        assertEquals(false, new y().test(-12));
        assertEquals(false, new y().test(-11));
        assertEquals(false, new y().test(-10));
        assertEquals(false, new y().test(0));
        assertEquals(false, new y().test(1));
        assertEquals(false, new y().test(2));
        assertEquals(false, new y().test(3));
        assertEquals(false, new y().test(4));
    }

    /**
     * Test of isAbove method, of class Fragment.
     */
    @Test
    public void testIsUpperThan_Fragment() {
        class x {
            Range<Integer> tested = new Between<>(-12, 2, order);
            boolean test(Range<Integer> f) {
                return tested.isUpperThan(f);
            }
        }
        assertEquals(true , new x().test(new Between<>(-36, -14, order))); //-   - |     |
        assertEquals(true , new x().test(new Between<>(-36, -13, order))); //-    -|     |
        assertEquals(true , new x().test(new Between<>(-36, -12, order))); //-     +     |
        assertEquals(false, new x().test(new Between<>(-36, -11, order))); //-     |-    |
        assertEquals(false, new x().test(new Between<>(-36, -10, order))); //-     | -   |
        assertEquals(false, new x().test(new Between<>(-36,   0, order))); //-     |   - |
        assertEquals(false, new x().test(new Between<>(-36,   1, order))); //-     |    -|
        assertEquals(false, new x().test(new Between<>(-36,   2, order))); //-     |     +
        assertEquals(false, new x().test(new Between<>(-36,   3, order))); //-     |     |-
        assertEquals(false, new x().test(new Between<>(-36,   4, order))); //-     |     | -
        assertEquals(false, new x().test(new Between<>(-14,  24, order))); //    - |     |    -
        assertEquals(false, new x().test(new Between<>(-13,  24, order))); //     -|     |    -
        assertEquals(false, new x().test(new Between<>(-12,  24, order))); //      +     |    -
        assertEquals(false, new x().test(new Between<>(-11,  24, order))); //      |-    |    -
        assertEquals(false, new x().test(new Between<>(-10,  24, order))); //      | -   |    -
        assertEquals(false, new x().test(new Between<>(  0,  24, order))); //      |   - |    -
        assertEquals(false, new x().test(new Between<>(  1,  24, order))); //      |    -|    -
        assertEquals(false, new x().test(new Between<>(  2,  24, order))); //      |     +    -
        assertEquals(false, new x().test(new Between<>(  3,  24, order))); //      |     |-   -
        assertEquals(false, new x().test(new Between<>(  4,  24, order))); //      |     | -  -
        assertEquals(false, new x().test(new Between<>(-14,   0, order))); //    - |   - |
        assertEquals(false, new x().test(new Between<>(-13,   0, order))); //     -|   - |
        assertEquals(false, new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(false, new x().test(new Between<>(-11,   0, order))); //      |-  - |
        assertEquals(false, new x().test(new Between<>(-10,   0, order))); //      | - - |
        assertEquals(false, new x().test(new Between<>(-10,   1, order))); //      | -  -|
        assertEquals(false, new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(false, new x().test(new Between<>(-10,   3, order))); //      | -   |-
        assertEquals(false, new x().test(new Between<>(-10,   4, order))); //      | -   | -
        assertEquals(false, new x().test(new Between<>(-14,   2, order))); //    - |     +
        assertEquals(false, new x().test(new Between<>(-13,   2, order))); //     -|     +
        assertEquals(false, new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(false, new x().test(new Between<>(-11,   2, order))); //      |-    +
        assertEquals(false, new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(false, new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(false, new x().test(new Between<>(-12,   1, order))); //      +    -|
        assertEquals(false, new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(false, new x().test(new Between<>(-12,   3, order))); //      +     |-
        assertEquals(false, new x().test(new Between<>(-12,   4, order))); //      +     | -
    }

    /**
     * Test of isBelow method, of class Fragment.
     */
    @Test
    public void testIsBelow_GenericType() {
        class y {
            Range<Integer> tested = new Between<>(-12, 2, order);
            boolean test(int f) {
                return tested.isBelow(f);
            }
        }
        assertEquals(false, new y().test(-14));
        assertEquals(false, new y().test(-13));
        assertEquals(false, new y().test(-12));
        assertEquals(false, new y().test(-11));
        assertEquals(false, new y().test(-10));
        assertEquals(false, new y().test(0));
        assertEquals(false, new y().test(1));
        assertEquals(false, new y().test(2));
        assertEquals(true , new y().test(3));
        assertEquals(true , new y().test(4));
    }

    /**
     * Test of isBelow method, of class Fragment.
     */
    @Test
    public void testIsLowerThan_Fragment() {
        class x {
            Range<Integer> tested = new Between<>(-12, 2, order);
            boolean test(Range<Integer> f) {
                return tested.isLowerThan(f);
            }
        }
        assertEquals(false, new x().test(new Between<>(-36, -14, order))); //-   - |     |
        assertEquals(false, new x().test(new Between<>(-36, -13, order))); //-    -|     |
        assertEquals(false, new x().test(new Between<>(-36, -12, order))); //-     +     |
        assertEquals(false, new x().test(new Between<>(-36, -11, order))); //-     |-    |
        assertEquals(false, new x().test(new Between<>(-36, -10, order))); //-     | -   |
        assertEquals(false, new x().test(new Between<>(-36,   0, order))); //-     |   - |
        assertEquals(false, new x().test(new Between<>(-36,   1, order))); //-     |    -|
        assertEquals(false, new x().test(new Between<>(-36,   2, order))); //-     |     +
        assertEquals(false, new x().test(new Between<>(-36,   3, order))); //-     |     |-
        assertEquals(false, new x().test(new Between<>(-36,   4, order))); //-     |     | -
        assertEquals(false, new x().test(new Between<>(-14,  24, order))); //    - |     |    -
        assertEquals(false, new x().test(new Between<>(-13,  24, order))); //     -|     |    -
        assertEquals(false, new x().test(new Between<>(-12,  24, order))); //      +     |    -
        assertEquals(false, new x().test(new Between<>(-11,  24, order))); //      |-    |    -
        assertEquals(false, new x().test(new Between<>(-10,  24, order))); //      | -   |    -
        assertEquals(false, new x().test(new Between<>(  0,  24, order))); //      |   - |    -
        assertEquals(false, new x().test(new Between<>(  1,  24, order))); //      |    -|    -
        assertEquals(true , new x().test(new Between<>(  2,  24, order))); //      |     +    -
        assertEquals(true , new x().test(new Between<>(  3,  24, order))); //      |     |-   -
        assertEquals(true , new x().test(new Between<>(  4,  24, order))); //      |     | -  -
        assertEquals(false, new x().test(new Between<>(-14,   0, order))); //    - |   - |
        assertEquals(false, new x().test(new Between<>(-13,   0, order))); //     -|   - |
        assertEquals(false, new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(false, new x().test(new Between<>(-11,   0, order))); //      |-  - |
        assertEquals(false, new x().test(new Between<>(-10,   0, order))); //      | - - |
        assertEquals(false, new x().test(new Between<>(-10,   1, order))); //      | -  -|
        assertEquals(false, new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(false, new x().test(new Between<>(-10,   3, order))); //      | -   |-
        assertEquals(false, new x().test(new Between<>(-10,   4, order))); //      | -   | -
        assertEquals(false, new x().test(new Between<>(-14,   2, order))); //    - |     +
        assertEquals(false, new x().test(new Between<>(-13,   2, order))); //     -|     +
        assertEquals(false, new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(false, new x().test(new Between<>(-11,   2, order))); //      |-    +
        assertEquals(false, new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(false, new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(false, new x().test(new Between<>(-12,   1, order))); //      +    -|
        assertEquals(false, new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(false, new x().test(new Between<>(-12,   3, order))); //      +     |-
        assertEquals(false, new x().test(new Between<>(-12,   4, order))); //      +     | -
    }

    /**
     * Test of isAbove method, of class Fragment.
     */
    @Test
    public void testIsAbove_Fragment() {
        class x {
            Range<Integer> tested = new Between<>(-12, 2, order);
            boolean test(Range<Integer> f) {
                return tested.isAbove(f);
            }
        }
        assertEquals(true , new x().test(new Between<>(-36, -14, order))); //-   - |     |
        assertEquals(true , new x().test(new Between<>(-36, -13, order))); //-    -|     |
        assertEquals(false, new x().test(new Between<>(-36, -12, order))); //-     +     |
        assertEquals(false, new x().test(new Between<>(-36, -11, order))); //-     |-    |
        assertEquals(false, new x().test(new Between<>(-36, -10, order))); //-     | -   |
        assertEquals(false, new x().test(new Between<>(-36,   0, order))); //-     |   - |
        assertEquals(false, new x().test(new Between<>(-36,   1, order))); //-     |    -|
        assertEquals(false, new x().test(new Between<>(-36,   2, order))); //-     |     +
        assertEquals(false, new x().test(new Between<>(-36,   3, order))); //-     |     |-
        assertEquals(false, new x().test(new Between<>(-36,   4, order))); //-     |     | -
        assertEquals(false, new x().test(new Between<>(-14,  24, order))); //    - |     |    -
        assertEquals(false, new x().test(new Between<>(-13,  24, order))); //     -|     |    -
        assertEquals(false, new x().test(new Between<>(-12,  24, order))); //      +     |    -
        assertEquals(false, new x().test(new Between<>(-11,  24, order))); //      |-    |    -
        assertEquals(false, new x().test(new Between<>(-10,  24, order))); //      | -   |    -
        assertEquals(false, new x().test(new Between<>(  0,  24, order))); //      |   - |    -
        assertEquals(false, new x().test(new Between<>(  1,  24, order))); //      |    -|    -
        assertEquals(false, new x().test(new Between<>(  2,  24, order))); //      |     +    -
        assertEquals(false, new x().test(new Between<>(  3,  24, order))); //      |     |-   -
        assertEquals(false, new x().test(new Between<>(  4,  24, order))); //      |     | -  -
        assertEquals(false, new x().test(new Between<>(-14,   0, order))); //    - |   - |
        assertEquals(false, new x().test(new Between<>(-13,   0, order))); //     -|   - |
        assertEquals(false, new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(false, new x().test(new Between<>(-11,   0, order))); //      |-  - |
        assertEquals(false, new x().test(new Between<>(-10,   0, order))); //      | - - |
        assertEquals(false, new x().test(new Between<>(-10,   1, order))); //      | -  -|
        assertEquals(false, new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(false, new x().test(new Between<>(-10,   3, order))); //      | -   |-
        assertEquals(false, new x().test(new Between<>(-10,   4, order))); //      | -   | -
        assertEquals(false, new x().test(new Between<>(-14,   2, order))); //    - |     +
        assertEquals(false, new x().test(new Between<>(-13,   2, order))); //     -|     +
        assertEquals(false, new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(false, new x().test(new Between<>(-11,   2, order))); //      |-    +
        assertEquals(false, new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(false, new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(false, new x().test(new Between<>(-12,   1, order))); //      +    -|
        assertEquals(false, new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(false, new x().test(new Between<>(-12,   3, order))); //      +     |-
        assertEquals(false, new x().test(new Between<>(-12,   4, order))); //      +     | -
    }

    /**
     * Test of isBelow method, of class Fragment.
     */
    @Test
    public void testIsBelow_Fragment() {
        class x {
            Range<Integer> tested = new Between<>(-12, 2, order);
            boolean test(Range<Integer> f) {
                return tested.isBelow(f);
            }
        }
        assertEquals(false, new x().test(new Between<>(-36, -14, order))); //-   - |     |
        assertEquals(false, new x().test(new Between<>(-36, -13, order))); //-    -|     |
        assertEquals(false, new x().test(new Between<>(-36, -12, order))); //-     +     |
        assertEquals(false, new x().test(new Between<>(-36, -11, order))); //-     |-    |
        assertEquals(false, new x().test(new Between<>(-36, -10, order))); //-     | -   |
        assertEquals(false, new x().test(new Between<>(-36,   0, order))); //-     |   - |
        assertEquals(false, new x().test(new Between<>(-36,   1, order))); //-     |    -|
        assertEquals(false, new x().test(new Between<>(-36,   2, order))); //-     |     +
        assertEquals(false, new x().test(new Between<>(-36,   3, order))); //-     |     |-
        assertEquals(false, new x().test(new Between<>(-36,   4, order))); //-     |     | -
        assertEquals(false, new x().test(new Between<>(-14,  24, order))); //    - |     |    -
        assertEquals(false, new x().test(new Between<>(-13,  24, order))); //     -|     |    -
        assertEquals(false, new x().test(new Between<>(-12,  24, order))); //      +     |    -
        assertEquals(false, new x().test(new Between<>(-11,  24, order))); //      |-    |    -
        assertEquals(false, new x().test(new Between<>(-10,  24, order))); //      | -   |    -
        assertEquals(false, new x().test(new Between<>(  0,  24, order))); //      |   - |    -
        assertEquals(false, new x().test(new Between<>(  1,  24, order))); //      |    -|    -
        assertEquals(false, new x().test(new Between<>(  2,  24, order))); //      |     +    -
        assertEquals(true , new x().test(new Between<>(  3,  24, order))); //      |     |-   -
        assertEquals(true , new x().test(new Between<>(  4,  24, order))); //      |     | -  -
        assertEquals(false, new x().test(new Between<>(-14,   0, order))); //    - |   - |
        assertEquals(false, new x().test(new Between<>(-13,   0, order))); //     -|   - |
        assertEquals(false, new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(false, new x().test(new Between<>(-11,   0, order))); //      |-  - |
        assertEquals(false, new x().test(new Between<>(-10,   0, order))); //      | - - |
        assertEquals(false, new x().test(new Between<>(-10,   1, order))); //      | -  -|
        assertEquals(false, new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(false, new x().test(new Between<>(-10,   3, order))); //      | -   |-
        assertEquals(false, new x().test(new Between<>(-10,   4, order))); //      | -   | -
        assertEquals(false, new x().test(new Between<>(-14,   2, order))); //    - |     +
        assertEquals(false, new x().test(new Between<>(-13,   2, order))); //     -|     +
        assertEquals(false, new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(false, new x().test(new Between<>(-11,   2, order))); //      |-    +
        assertEquals(false, new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(false, new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(false, new x().test(new Between<>(-12,   1, order))); //      +    -|
        assertEquals(false, new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(false, new x().test(new Between<>(-12,   3, order))); //      +     |-
        assertEquals(false, new x().test(new Between<>(-12,   4, order))); //      +     | -
    }

    /**
     * Test of doesOverrap method, of class Fragment.
     */
    @Test
    public void testDoesOverlap() {
        class x {
            Range<Integer> tested = new Between<>(-12, 2, order);
            boolean test(Range<Integer> f) {
                return tested.overlaps(f);
            }
        }
        assertEquals(false, new x().test(new Between<>(-36, -14, order))); //-   - |     |
        assertEquals(false, new x().test(new Between<>(-36, -13, order))); //-    -|     |
        assertEquals(false, new x().test(new Between<>(-36, -12, order))); //-     +     |
        assertEquals(true , new x().test(new Between<>(-36, -11, order))); //-     |-    |
        assertEquals(true , new x().test(new Between<>(-36, -10, order))); //-     | -   |
        assertEquals(true , new x().test(new Between<>(-36,   0, order))); //-     |   - |
        assertEquals(true , new x().test(new Between<>(-36,   1, order))); //-     |    -|
        assertEquals(true , new x().test(new Between<>(-36,   2, order))); //-     |     +
        assertEquals(true , new x().test(new Between<>(-36,   3, order))); //-     |     |-
        assertEquals(true , new x().test(new Between<>(-36,   4, order))); //-     |     | -
        assertEquals(true , new x().test(new Between<>(-14,  24, order))); //    - |     |    -
        assertEquals(true , new x().test(new Between<>(-13,  24, order))); //     -|     |    -
        assertEquals(true , new x().test(new Between<>(-12,  24, order))); //      +     |    -
        assertEquals(true , new x().test(new Between<>(-11,  24, order))); //      |-    |    -
        assertEquals(true , new x().test(new Between<>(-10,  24, order))); //      | -   |    -
        assertEquals(true , new x().test(new Between<>(  0,  24, order))); //      |   - |    -
        assertEquals(true , new x().test(new Between<>(  1,  24, order))); //      |    -|    -
        assertEquals(false, new x().test(new Between<>(  2,  24, order))); //      |     +    -
        assertEquals(false, new x().test(new Between<>(  3,  24, order))); //      |     |-   -
        assertEquals(false, new x().test(new Between<>(  4,  24, order))); //      |     | -  -
        assertEquals(true , new x().test(new Between<>(-14,   0, order))); //    - |   - |
        assertEquals(true , new x().test(new Between<>(-13,   0, order))); //     -|   - |
        assertEquals(true , new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(true , new x().test(new Between<>(-11,   0, order))); //      |-  - |
        assertEquals(true , new x().test(new Between<>(-10,   0, order))); //      | - - |
        assertEquals(true , new x().test(new Between<>(-10,   1, order))); //      | -  -|
        assertEquals(true , new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(true , new x().test(new Between<>(-10,   3, order))); //      | -   |-
        assertEquals(true , new x().test(new Between<>(-10,   4, order))); //      | -   | -
        assertEquals(true , new x().test(new Between<>(-14,   2, order))); //    - |     +
        assertEquals(true , new x().test(new Between<>(-13,   2, order))); //     -|     +
        assertEquals(true , new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(true , new x().test(new Between<>(-11,   2, order))); //      |-    +
        assertEquals(true , new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(true , new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(true , new x().test(new Between<>(-12,   1, order))); //      +    -|
        assertEquals(true , new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(true , new x().test(new Between<>(-12,   3, order))); //      +     |-
        assertEquals(true , new x().test(new Between<>(-12,   4, order))); //      +     | -
    }

    /**
     * Test of contains method, of class Fragment.
     */
    @Test
    public void testDoesContain_Fragment() {
        class x {
            Range<Integer> tested = new Between<>(-12, 2, order);
            boolean test(Range<Integer> f) {
                return tested.contains(f);
            }
        }
        assertEquals(false, new x().test(new Between<>(-36, -14, order))); //-   - |     |
        assertEquals(false, new x().test(new Between<>(-36, -13, order))); //-    -|     |
        assertEquals(false, new x().test(new Between<>(-36, -12, order))); //-     +     |
        assertEquals(false, new x().test(new Between<>(-36, -11, order))); //-     |-    |
        assertEquals(false, new x().test(new Between<>(-36, -10, order))); //-     | -   |
        assertEquals(false, new x().test(new Between<>(-36,   0, order))); //-     |   - |
        assertEquals(false, new x().test(new Between<>(-36,   1, order))); //-     |    -|
        assertEquals(false, new x().test(new Between<>(-36,   2, order))); //-     |     +
        assertEquals(false, new x().test(new Between<>(-36,   3, order))); //-     |     |-
        assertEquals(false, new x().test(new Between<>(-36,   4, order))); //-     |     | -
        assertEquals(false, new x().test(new Between<>(-14,  24, order))); //    - |     |    -
        assertEquals(false, new x().test(new Between<>(-13,  24, order))); //     -|     |    -
        assertEquals(false, new x().test(new Between<>(-12,  24, order))); //      +     |    -
        assertEquals(false, new x().test(new Between<>(-11,  24, order))); //      |-    |    -
        assertEquals(false, new x().test(new Between<>(-10,  24, order))); //      | -   |    -
        assertEquals(false, new x().test(new Between<>(  0,  24, order))); //      |   - |    -
        assertEquals(false, new x().test(new Between<>(  1,  24, order))); //      |    -|    -
        assertEquals(false, new x().test(new Between<>(  2,  24, order))); //      |     +    -
        assertEquals(false, new x().test(new Between<>(  3,  24, order))); //      |     |-   -
        assertEquals(false, new x().test(new Between<>(  4,  24, order))); //      |     | -  -
        assertEquals(false, new x().test(new Between<>(-14,   0, order))); //    - |   - |
        assertEquals(false, new x().test(new Between<>(-13,   0, order))); //     -|   - |
        assertEquals(true , new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(true , new x().test(new Between<>(-11,   0, order))); //      |-  - |
        assertEquals(true , new x().test(new Between<>(-10,   0, order))); //      | - - |
        assertEquals(true , new x().test(new Between<>(-10,   1, order))); //      | -  -|
        assertEquals(true , new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(false, new x().test(new Between<>(-10,   3, order))); //      | -   |-
        assertEquals(false, new x().test(new Between<>(-10,   4, order))); //      | -   | -
        assertEquals(false, new x().test(new Between<>(-14,   2, order))); //    - |     +
        assertEquals(false, new x().test(new Between<>(-13,   2, order))); //     -|     +
        assertEquals(true , new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(true , new x().test(new Between<>(-11,   2, order))); //      |-    +
        assertEquals(true , new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(true , new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(true , new x().test(new Between<>(-12,   1, order))); //      +    -|
        assertEquals(true , new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(false, new x().test(new Between<>(-12,   3, order))); //      +     |-
        assertEquals(false, new x().test(new Between<>(-12,   4, order))); //      +     | -
    }

    /**
     * Test of adjoins method, of class Fragment.
     */
    @Test
    public void testDoesAdjoin() {
        class x {
            Range<Integer> tested = new Between<>(-12, 2, order);
            boolean test(Range<Integer> f) {
                return tested.adjoins(f);
            }
        }
        assertEquals(false, new x().test(new Between<>(-36, -14, order))); //-   - |     |
        assertEquals(false, new x().test(new Between<>(-36, -13, order))); //-    -|     |
        assertEquals(true , new x().test(new Between<>(-36, -12, order))); //-     +     |
        assertEquals(false, new x().test(new Between<>(-36, -11, order))); //-     |-    |
        assertEquals(false, new x().test(new Between<>(-36, -10, order))); //-     | -   |
        assertEquals(false, new x().test(new Between<>(-36,   0, order))); //-     |   - |
        assertEquals(false, new x().test(new Between<>(-36,   1, order))); //-     |    -|
        assertEquals(false, new x().test(new Between<>(-36,   2, order))); //-     |     +
        assertEquals(false, new x().test(new Between<>(-36,   3, order))); //-     |     |-
        assertEquals(false, new x().test(new Between<>(-36,   4, order))); //-     |     | -
        assertEquals(false, new x().test(new Between<>(-14,  24, order))); //    - |     |    -
        assertEquals(false, new x().test(new Between<>(-13,  24, order))); //     -|     |    -
        assertEquals(false, new x().test(new Between<>(-12,  24, order))); //      +     |    -
        assertEquals(false, new x().test(new Between<>(-11,  24, order))); //      |-    |    -
        assertEquals(false, new x().test(new Between<>(-10,  24, order))); //      | -   |    -
        assertEquals(false, new x().test(new Between<>(  0,  24, order))); //      |   - |    -
        assertEquals(false, new x().test(new Between<>(  1,  24, order))); //      |    -|    -
        assertEquals(true , new x().test(new Between<>(  2,  24, order))); //      |     +    -
        assertEquals(false, new x().test(new Between<>(  3,  24, order))); //      |     |-   -
        assertEquals(false, new x().test(new Between<>(  4,  24, order))); //      |     | -  -
        assertEquals(false, new x().test(new Between<>(-14,   2, order))); //    - |     +
        assertEquals(false, new x().test(new Between<>(-13,   2, order))); //     -|     +
        assertEquals(false, new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(false, new x().test(new Between<>(-11,   2, order))); //      |-    +
        assertEquals(false, new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(false, new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(false, new x().test(new Between<>(-12,   1, order))); //      +    -|
        assertEquals(false, new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(false, new x().test(new Between<>(-12,   3, order))); //      +     |-
        assertEquals(false, new x().test(new Between<>(-12,   4, order))); //      +     | -
    }

    /**
     * Test of adjoinsAtStartWith method, of class Fragment.
     */
    @Test
    public void testDoesAdjoinAtStart() {
        class x {
            Range<Integer> tested = new Between<>(-12, 2, order);
            boolean test(Range<Integer> f) {
                return tested.adjoinsAtStartWith(f);
            }
        }
        assertEquals(false, new x().test(new Between<>(-36, -14, order))); //-   - |     |
        assertEquals(false, new x().test(new Between<>(-36, -13, order))); //-    -|     |
        assertEquals(true , new x().test(new Between<>(-36, -12, order))); //-     +     |
        assertEquals(false, new x().test(new Between<>(-36, -11, order))); //-     |-    |
        assertEquals(false, new x().test(new Between<>(-36, -10, order))); //-     | -   |
        assertEquals(false, new x().test(new Between<>(-36,   0, order))); //-     |   - |
        assertEquals(false, new x().test(new Between<>(-36,   1, order))); //-     |    -|
        assertEquals(false, new x().test(new Between<>(-36,   2, order))); //-     |     +
        assertEquals(false, new x().test(new Between<>(-36,   3, order))); //-     |     |-
        assertEquals(false, new x().test(new Between<>(-36,   4, order))); //-     |     | -
        assertEquals(false, new x().test(new Between<>(-14,  24, order))); //    - |     |    -
        assertEquals(false, new x().test(new Between<>(-13,  24, order))); //     -|     |    -
        assertEquals(false, new x().test(new Between<>(-12,  24, order))); //      +     |    -
        assertEquals(false, new x().test(new Between<>(-11,  24, order))); //      |-    |    -
        assertEquals(false, new x().test(new Between<>(-10,  24, order))); //      | -   |    -
        assertEquals(false, new x().test(new Between<>(  0,  24, order))); //      |   - |    -
        assertEquals(false, new x().test(new Between<>(  1,  24, order))); //      |    -|    -
        assertEquals(false, new x().test(new Between<>(  2,  24, order))); //      |     +    -
        assertEquals(false, new x().test(new Between<>(  3,  24, order))); //      |     |-   -
        assertEquals(false, new x().test(new Between<>(  4,  24, order))); //      |     | -  -
        assertEquals(false, new x().test(new Between<>(-14,   0, order))); //    - |   - |
        assertEquals(false, new x().test(new Between<>(-13,   0, order))); //     -|   - |
        assertEquals(false, new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(false, new x().test(new Between<>(-11,   0, order))); //      |-  - |
        assertEquals(false, new x().test(new Between<>(-10,   0, order))); //      | - - |
        assertEquals(false, new x().test(new Between<>(-10,   1, order))); //      | -  -|
        assertEquals(false, new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(false, new x().test(new Between<>(-10,   3, order))); //      | -   |-
        assertEquals(false, new x().test(new Between<>(-10,   4, order))); //      | -   | -
        assertEquals(false, new x().test(new Between<>(-14,   2, order))); //    - |     +
        assertEquals(false, new x().test(new Between<>(-13,   2, order))); //     -|     +
        assertEquals(false, new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(false, new x().test(new Between<>(-11,   2, order))); //      |-    +
        assertEquals(false, new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(false, new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(false, new x().test(new Between<>(-12,   1, order))); //      +    -|
        assertEquals(false, new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(false, new x().test(new Between<>(-12,   3, order))); //      +     |-
        assertEquals(false, new x().test(new Between<>(-12,   4, order))); //      +     | -
    }

    /**
     * Test of adjoinsAtEndWith method, of class Fragment.
     */
    @Test
    public void testDoesAdjoinAtEnd() {
        class x {
            Range<Integer> tested = new Between<>(-12, 2, order);
            boolean test(Range<Integer> f) {
                return tested.adjoinsAtEndWith(f);
            }
        }
        assertEquals(false, new x().test(new Between<>(-36, -14, order))); //-   - |     |
        assertEquals(false, new x().test(new Between<>(-36, -13, order))); //-    -|     |
        assertEquals(false, new x().test(new Between<>(-36, -12, order))); //-     +     |
        assertEquals(false, new x().test(new Between<>(-36, -11, order))); //-     |-    |
        assertEquals(false, new x().test(new Between<>(-36, -10, order))); //-     | -   |
        assertEquals(false, new x().test(new Between<>(-36,   0, order))); //-     |   - |
        assertEquals(false, new x().test(new Between<>(-36,   1, order))); //-     |    -|
        assertEquals(false, new x().test(new Between<>(-36,   2, order))); //-     |     +
        assertEquals(false, new x().test(new Between<>(-36,   3, order))); //-     |     |-
        assertEquals(false, new x().test(new Between<>(-36,   4, order))); //-     |     | -
        assertEquals(false, new x().test(new Between<>(-14,  24, order))); //    - |     |    -
        assertEquals(false, new x().test(new Between<>(-13,  24, order))); //     -|     |    -
        assertEquals(false, new x().test(new Between<>(-12,  24, order))); //      +     |    -
        assertEquals(false, new x().test(new Between<>(-11,  24, order))); //      |-    |    -
        assertEquals(false, new x().test(new Between<>(-10,  24, order))); //      | -   |    -
        assertEquals(false, new x().test(new Between<>(  0,  24, order))); //      |   - |    -
        assertEquals(false, new x().test(new Between<>(  1,  24, order))); //      |    -|    -
        assertEquals(true , new x().test(new Between<>(  2,  24, order))); //      |     +    -
        assertEquals(false, new x().test(new Between<>(  3,  24, order))); //      |     |-   -
        assertEquals(false, new x().test(new Between<>(  4,  24, order))); //      |     | -  -
        assertEquals(false, new x().test(new Between<>(-14,   0, order))); //    - |   - |
        assertEquals(false, new x().test(new Between<>(-13,   0, order))); //     -|   - |
        assertEquals(false, new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(false, new x().test(new Between<>(-11,   0, order))); //      |-  - |
        assertEquals(false, new x().test(new Between<>(-10,   0, order))); //      | - - |
        assertEquals(false, new x().test(new Between<>(-10,   1, order))); //      | -  -|
        assertEquals(false, new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(false, new x().test(new Between<>(-10,   3, order))); //      | -   |-
        assertEquals(false, new x().test(new Between<>(-10,   4, order))); //      | -   | -
        assertEquals(false, new x().test(new Between<>(-14,   2, order))); //    - |     +
        assertEquals(false, new x().test(new Between<>(-13,   2, order))); //     -|     +
        assertEquals(false, new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(false, new x().test(new Between<>(-11,   2, order))); //      |-    +
        assertEquals(false, new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(false, new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(false, new x().test(new Between<>(-12,   1, order))); //      +    -|
        assertEquals(false, new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(false, new x().test(new Between<>(-12,   3, order))); //      +     |-
        assertEquals(false, new x().test(new Between<>(-12,   4, order))); //      +     | -
    }

    /**
     * Test of intersect method, of class Fragment.
     */
    @Test
    public void testIntersect() {
        class x {
            Range<Integer> tested = new Between<>(-12, 2, order);
            Range<Integer> test(Range<Integer> f) {
                return tested.intersect(f);
            }
        }
        assertEquals(new Empty<>()          , new x().test(new Between<>(-36, -14, order))); //-   - |     |
        assertEquals(new Empty<>()          , new x().test(new Between<>(-36, -13, order))); //-    -|     |
        assertEquals(new Empty<>()          , new x().test(new Between<>(-36, -12, order))); //-     +     |
        assertEquals(new Between<>(-12, -11, order), new x().test(new Between<>(-36, -11, order))); //-     |-    |
        assertEquals(new Between<>(-12, -10, order), new x().test(new Between<>(-36, -10, order))); //-     | -   |
        assertEquals(new Between<>(-12,   0, order), new x().test(new Between<>(-36,   0, order))); //-     |   - |
        assertEquals(new Between<>(-12,   1, order), new x().test(new Between<>(-36,   1, order))); //-     |    -|
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-36,   2, order))); //-     |     +
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-36,   3, order))); //-     |     |-
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-36,   4, order))); //-     |     | -
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-14,  24, order))); //    - |     |    -
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-13,  24, order))); //     -|     |    -
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-12,  24, order))); //      +     |    -
        assertEquals(new Between<>(-11,   2, order), new x().test(new Between<>(-11,  24, order))); //      |-    |    -
        assertEquals(new Between<>(-10,   2, order), new x().test(new Between<>(-10,  24, order))); //      | -   |    -
        assertEquals(new Between<>(  0,   2, order), new x().test(new Between<>(  0,  24, order))); //      |   - |    -
        assertEquals(new Between<>(  1,   2, order), new x().test(new Between<>(  1,  24, order))); //      |    -|    -
        assertEquals(new Empty<>()          , new x().test(new Between<>(  2,  24, order))); //      |     +    -
        assertEquals(new Empty<>()          , new x().test(new Between<>(  3,  24, order))); //      |     |-   -
        assertEquals(new Empty<>()          , new x().test(new Between<>(  4,  24, order))); //      |     | -  -
        assertEquals(new Between<>(-12,   0, order), new x().test(new Between<>(-14,   0, order))); //    - |   - |
        assertEquals(new Between<>(-12,   0, order), new x().test(new Between<>(-13,   0, order))); //     -|   - |
        assertEquals(new Between<>(-12,   0, order), new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(new Between<>(-11,   0, order), new x().test(new Between<>(-11,   0, order))); //      |-  - |
        assertEquals(new Between<>(-10,   0, order), new x().test(new Between<>(-10,   0, order))); //      | - - |
        assertEquals(new Between<>(-10,   1, order), new x().test(new Between<>(-10,   1, order))); //      | -  -|
        assertEquals(new Between<>(-10,   2, order), new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(new Between<>(-10,   2, order), new x().test(new Between<>(-10,   3, order))); //      | -   |-
        assertEquals(new Between<>(-10,   2, order), new x().test(new Between<>(-10,   4, order))); //      | -   | -
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-14,   2, order))); //    - |     +
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-13,   2, order))); //     -|     +
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(new Between<>(-11,   2, order), new x().test(new Between<>(-11,   2, order))); //      |-    +
        assertEquals(new Between<>(-10,   2, order), new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(new Between<>(-12,   0, order), new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(new Between<>(-12,   1, order), new x().test(new Between<>(-12,   1, order))); //      +    -|
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-12,   3, order))); //      +     |-
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-12,   4, order))); //      +     | -
    }

    /**
     * Test of cover method, of class Fragment.
     */
    @Test
    public void testCover() {
        class x {
            Range<Integer> tested = new Between<>(-12, 2, order);
            Range<Integer> test(Range<Integer> f) {
                return tested.cover(f);
            }
        }
        assertEquals(new Between<>(-36,   2, order), new x().test(new Between<>(-36, -14, order))); //-   - |     |
        assertEquals(new Between<>(-36,   2, order), new x().test(new Between<>(-36, -13, order))); //-    -|     |
        assertEquals(new Between<>(-36,   2, order), new x().test(new Between<>(-36, -12, order))); //-     +     |
        assertEquals(new Between<>(-36,   2, order), new x().test(new Between<>(-36, -11, order))); //-     |-    |
        assertEquals(new Between<>(-36,   2, order), new x().test(new Between<>(-36, -10, order))); //-     | -   |
        assertEquals(new Between<>(-36,   2, order), new x().test(new Between<>(-36,   0, order))); //-     |   - |
        assertEquals(new Between<>(-36,   2, order), new x().test(new Between<>(-36,   1, order))); //-     |    -|
        assertEquals(new Between<>(-36,   2, order), new x().test(new Between<>(-36,   2, order))); //-     |     +
        assertEquals(new Between<>(-36,   3, order), new x().test(new Between<>(-36,   3, order))); //-     |     |-
        assertEquals(new Between<>(-36,   4, order), new x().test(new Between<>(-36,   4, order))); //-     |     | -
        assertEquals(new Between<>(-14,  24, order), new x().test(new Between<>(-14,  24, order))); //    - |     |    -
        assertEquals(new Between<>(-13,  24, order), new x().test(new Between<>(-13,  24, order))); //     -|     |    -
        assertEquals(new Between<>(-12,  24, order), new x().test(new Between<>(-12,  24, order))); //      +     |    -
        assertEquals(new Between<>(-12,  24, order), new x().test(new Between<>(-11,  24, order))); //      |-    |    -
        assertEquals(new Between<>(-12,  24, order), new x().test(new Between<>(-10,  24, order))); //      | -   |    -
        assertEquals(new Between<>(-12,  24, order), new x().test(new Between<>(  0,  24, order))); //      |   - |    -
        assertEquals(new Between<>(-12,  24, order), new x().test(new Between<>(  1,  24, order))); //      |    -|    -
        assertEquals(new Between<>(-12,  24, order), new x().test(new Between<>(  2,  24, order))); //      |     +    -
        assertEquals(new Between<>(-12,  24, order), new x().test(new Between<>(  3,  24, order))); //      |     |-   -
        assertEquals(new Between<>(-12,  24, order), new x().test(new Between<>(  4,  24, order))); //      |     | -  -
        assertEquals(new Between<>(-14,   2, order), new x().test(new Between<>(-14,   0, order))); //    - |   - |
        assertEquals(new Between<>(-13,   2, order), new x().test(new Between<>(-13,   0, order))); //     -|   - |
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-11,   0, order))); //      |-  - |
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-10,   0, order))); //      | - - |
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-10,   1, order))); //      | -  -|
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(new Between<>(-12,   3, order), new x().test(new Between<>(-10,   3, order))); //      | -   |-
        assertEquals(new Between<>(-12,   4, order), new x().test(new Between<>(-10,   4, order))); //      | -   | -
        assertEquals(new Between<>(-14,   2, order), new x().test(new Between<>(-14,   2, order))); //    - |     +
        assertEquals(new Between<>(-13,   2, order), new x().test(new Between<>(-13,   2, order))); //     -|     +
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-11,   2, order))); //      |-    +
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-12,   1, order))); //      +    -|
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(new Between<>(-12,   3, order), new x().test(new Between<>(-12,   3, order))); //      +     |-
        assertEquals(new Between<>(-12,   4, order), new x().test(new Between<>(-12,   4, order))); //      +     | -
    }

    /**
     * Test of getUpper method, of class Fragment.
     */
    @Test
    public void testGetUpper_GenericType() {
        class y {
            Range<Integer> tested = new Between<>(-12, 2, order);
            Range<Integer> test(int f) {
                return tested.getUpper(f);
            }
        }
        assertEquals(new Between<>(-12,   2, order), new y().test(-14));
        assertEquals(new Between<>(-12,   2, order), new y().test(-13));
        assertEquals(new Between<>(-12,   2, order), new y().test(-12));
        assertEquals(new Between<>(-11,   2, order), new y().test(-11));
        assertEquals(new Between<>(-10,   2, order), new y().test(-10));
        assertEquals(new Between<>(  0,   2, order), new y().test(0));
        assertEquals(new Between<>(  1,   2, order), new y().test(1));
        assertEquals(new Empty<>()          , new y().test(2));
        assertEquals(new Empty<>()          , new y().test(3));
        assertEquals(new Empty<>()          , new y().test(4));
    }

    /**
     * Test of getUpper method, of class Fragment.
     */
    @Test
    public void testGetUpper_Fragment() {
        class x {
            Range<Integer> tested = new Between<>(-12, 2, order);
            Range<Integer> test(Range<Integer> f) {
                return f.getUpperRoomIn(tested);
            }
        }
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-36, -14, order))); //-   - |     |
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-36, -13, order))); //-    -|     |
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(-36, -12, order))); //-     +     |
        assertEquals(new Between<>(-11,   2, order), new x().test(new Between<>(-36, -11, order))); //-     |-    |
        assertEquals(new Between<>(-10,   2, order), new x().test(new Between<>(-36, -10, order))); //-     | -   |
        assertEquals(new Between<>(  0,   2, order), new x().test(new Between<>(-36,   0, order))); //-     |   - |
        assertEquals(new Between<>(  1,   2, order), new x().test(new Between<>(-36,   1, order))); //-     |    -|
        assertEquals(new Empty<>()          , new x().test(new Between<>(-36,   2, order))); //-     |     +
        assertEquals(new Empty<>()          , new x().test(new Between<>(-36,   3, order))); //-     |     |-
        assertEquals(new Empty<>()          , new x().test(new Between<>(-36,   4, order))); //-     |     | -
        assertEquals(new Empty<>()          , new x().test(new Between<>(-14,  24, order))); //    - |     |    -
        assertEquals(new Empty<>()          , new x().test(new Between<>(-13,  24, order))); //     -|     |    -
        assertEquals(new Empty<>()          , new x().test(new Between<>(-12,  24, order))); //      +     |    -
        assertEquals(new Empty<>()          , new x().test(new Between<>(-11,  24, order))); //      |-    |    -
        assertEquals(new Empty<>()          , new x().test(new Between<>(-10,  24, order))); //      | -   |    -
        assertEquals(new Empty<>()          , new x().test(new Between<>(  0,  24, order))); //      |   - |    -
        assertEquals(new Empty<>()          , new x().test(new Between<>(  1,  24, order))); //      |    -|    -
        assertEquals(new Empty<>()          , new x().test(new Between<>(  2,  24, order))); //      |     +    -
        assertEquals(new Empty<>()          , new x().test(new Between<>(  3,  24, order))); //      |     |-   -
        assertEquals(new Empty<>()          , new x().test(new Between<>(  4,  24, order))); //      |     | -  -
        assertEquals(new Between<>(  0,   2, order), new x().test(new Between<>(-14,   0, order))); //    - |   - |
        assertEquals(new Between<>(  0,   2, order), new x().test(new Between<>(-13,   0, order))); //     -|   - |
        assertEquals(new Between<>(  0,   2, order), new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(new Between<>(  0,   2, order), new x().test(new Between<>(-11,   0, order))); //      |-  - |
        assertEquals(new Between<>(  0,   2, order), new x().test(new Between<>(-10,   0, order))); //      | - - |
        assertEquals(new Between<>(  1,   2, order), new x().test(new Between<>(-10,   1, order))); //      | -  -|
        assertEquals(new Empty<>()          , new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(new Empty<>()          , new x().test(new Between<>(-10,   3, order))); //      | -   |-
        assertEquals(new Empty<>()          , new x().test(new Between<>(-10,   4, order))); //      | -   | -
        assertEquals(new Empty<>()          , new x().test(new Between<>(-14,   2, order))); //    - |     +
        assertEquals(new Empty<>()          , new x().test(new Between<>(-13,   2, order))); //     -|     +
        assertEquals(new Empty<>()          , new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(new Empty<>()          , new x().test(new Between<>(-11,   2, order))); //      |-    +
        assertEquals(new Empty<>()          , new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(new Between<>(  0,   2, order), new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(new Between<>(  1,   2, order), new x().test(new Between<>(-12,   1, order))); //      +    -|
        assertEquals(new Empty<>()          , new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(new Empty<>()          , new x().test(new Between<>(-12,   3, order))); //      +     |-
        assertEquals(new Empty<>()          , new x().test(new Between<>(-12,   4, order))); //      +     | -
    }

    /**
     * Test of getLower method, of class Fragment.
     */
    @Test
    public void testGetLower_GenericType() {
        class y {
            Range<Integer> tested = new Between<>(-12, 2, order);
            Range<Integer> test(int f) {
                return tested.getLower(f);
            }
        }
        assertEquals(new Empty<>()          , new y().test(-14));
        assertEquals(new Empty<>()          , new y().test(-13));
        assertEquals(new Empty<>()          , new y().test(-12));
        assertEquals(new Between<>(-12, -11, order), new y().test(-11));
        assertEquals(new Between<>(-12, -10, order), new y().test(-10));
        assertEquals(new Between<>(-12,   0, order), new y().test(0));
        assertEquals(new Between<>(-12,   1, order), new y().test(1));
        assertEquals(new Between<>(-12,   2, order), new y().test(2));
        assertEquals(new Between<>(-12,   2, order), new y().test(3));
        assertEquals(new Between<>(-12,   2, order), new y().test(4));
    }

    /**
     * Test of getLower method, of class Fragment.
     */
    @Test
    public void testGetLower_Fragment() {
        class x {
            Range<Integer> tested = new Between<>(-12, 2, order);
            Range<Integer> test(Range<Integer> f) {
                return f.getLowerRoomIn(tested);
            }
        }
        assertEquals(new Empty<>()          , new x().test(new Between<>(-36, -14, order))); //-   - |     |
        assertEquals(new Empty<>()          , new x().test(new Between<>(-36, -13, order))); //-    -|     |
        assertEquals(new Empty<>()          , new x().test(new Between<>(-36, -12, order))); //-     +     |
        assertEquals(new Empty<>()          , new x().test(new Between<>(-36, -11, order))); //-     |-    |
        assertEquals(new Empty<>()          , new x().test(new Between<>(-36, -10, order))); //-     | -   |
        assertEquals(new Empty<>()          , new x().test(new Between<>(-36,   0, order))); //-     |   - |
        assertEquals(new Empty<>()          , new x().test(new Between<>(-36,   1, order))); //-     |    -|
        assertEquals(new Empty<>()          , new x().test(new Between<>(-36,   2, order))); //-     |     +
        assertEquals(new Empty<>()          , new x().test(new Between<>(-36,   3, order))); //-     |     |-
        assertEquals(new Empty<>()          , new x().test(new Between<>(-36,   4, order))); //-     |     | -
        assertEquals(new Empty<>()          , new x().test(new Between<>(-14,  24, order))); //    - |     |    -
        assertEquals(new Empty<>()          , new x().test(new Between<>(-13,  24, order))); //     -|     |    -
        assertEquals(new Empty<>()          , new x().test(new Between<>(-12,  24, order))); //      +     |    -
        assertEquals(new Between<>(-12, -11, order), new x().test(new Between<>(-11,  24, order))); //      |-    |    -
        assertEquals(new Between<>(-12, -10, order), new x().test(new Between<>(-10,  24, order))); //      | -   |    -
        assertEquals(new Between<>(-12,   0, order), new x().test(new Between<>(  0,  24, order))); //      |   - |    -
        assertEquals(new Between<>(-12,   1, order), new x().test(new Between<>(  1,  24, order))); //      |    -|    -
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(  2,  24, order))); //      |     +    -
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(  3,  24, order))); //      |     |-   -
        assertEquals(new Between<>(-12,   2, order), new x().test(new Between<>(  4,  24, order))); //      |     | -  -
        assertEquals(new Empty<>()          , new x().test(new Between<>(-14,   0, order))); //    - |   - |
        assertEquals(new Empty<>()          , new x().test(new Between<>(-13,   0, order))); //     -|   - |
        assertEquals(new Empty<>()          , new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(new Between<>(-12, -11, order), new x().test(new Between<>(-11,   0, order))); //      |-  - |
        assertEquals(new Between<>(-12, -10, order), new x().test(new Between<>(-10,   0, order))); //      | - - |
        assertEquals(new Between<>(-12, -10, order), new x().test(new Between<>(-10,   1, order))); //      | -  -|
        assertEquals(new Between<>(-12, -10, order), new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(new Between<>(-12, -10, order), new x().test(new Between<>(-10,   3, order))); //      | -   |-
        assertEquals(new Between<>(-12, -10, order), new x().test(new Between<>(-10,   4, order))); //      | -   | -
        assertEquals(new Empty<>()          , new x().test(new Between<>(-14,   2, order))); //    - |     +
        assertEquals(new Empty<>()          , new x().test(new Between<>(-13,   2, order))); //     -|     +
        assertEquals(new Empty<>()          , new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(new Between<>(-12, -11, order), new x().test(new Between<>(-11,   2, order))); //      |-    +
        assertEquals(new Between<>(-12, -10, order), new x().test(new Between<>(-10,   2, order))); //      | -   +
        assertEquals(new Empty<>()          , new x().test(new Between<>(-12,   0, order))); //      +   - |
        assertEquals(new Empty<>()          , new x().test(new Between<>(-12,   1, order))); //      +    -|
        assertEquals(new Empty<>()          , new x().test(new Between<>(-12,   2, order))); //      +     +
        assertEquals(new Empty<>()          , new x().test(new Between<>(-12,   3, order))); //      +     |-
        assertEquals(new Empty<>()          , new x().test(new Between<>(-12,   4, order))); //      +     | -
    }
}
