/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;

import java.util.*;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

/**
 *
 * @author mtomono
 */
public class Iterators {
    public static <T> Stream<T> toStream(Iterator<T> iter) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iter, Spliterator.ORDERED), false);
    }
    
    public static <T> LongStream toLongStream(PrimitiveIterator.OfLong iter) {
        return StreamSupport.longStream(Spliterators.spliteratorUnknownSize(iter, Spliterator.ORDERED), false);
    }
    
    public static <T> IntStream toIntStream(PrimitiveIterator.OfInt iter) {
        return StreamSupport.intStream(Spliterators.spliteratorUnknownSize(iter, Spliterator.ORDERED), false);
    }
    
    public static <T> DoubleStream toDoubleStream(PrimitiveIterator.OfDouble iter) {
        return StreamSupport.doubleStream(Spliterators.spliteratorUnknownSize(iter, Spliterator.ORDERED), false);
    }
    
    public static <T> boolean test(Iterator<T> expected, Iterator<T> tested) {
        return toStream(tested).allMatch(n->expected.hasNext() && n.equals(expected.next())) && !expected.hasNext();
    }
    
    public static <T> ListIterator<T> buffer(Iterator<T> body, int depth) {
        return new RingBufferedListIterator<>(body, 2);
    }
}
