# Changelog

All notable changes to Luce will be documented in this file.

## [Unreleased]

* **Breaking change**: Changed `getter` and `property` which were of
  type `Bool` to `getter?` and `property?` respectively.
* **Breaking change**: `close()` of `DelimiterSyntax` and `LinkSyntax`
  returns multiple nodes instead of single one.
* **Breaking change**: Removed deprecated APIs, including `TagSyntax`,
  `Luce::INDICATOR_FOR_CHECKED_CHECK_BOX`, and
  `Luce::INDICATOR_FOR_UNCHECKED_CHECK_BOX`.
* **Breaking change** Removed `BlockHTMLSyntax`, `BlockTagBlockHTMLSyntax`,
  `LongBlockHTMLSyntax`, and `OtherTagBlockHTMLSyntax`.
* Add new syntax `HTMLBlockSyntax` to parse HTML blocks.
* Add new syntax `DecodeHtmlSyntax` to decode HTML entity and numeric
  character references.
* Add new syntax `EscapeHTMLSyntax` to encode (`"`), (`<`), (`>`) and (`&`).
* Add new syntax `SoftLineBreakSyntax` to remove the single space before the
  line ending.
* Add an option `case_sensitive` to `TextSyntax`.

## [0.3.0] - 2023-03-02

* **Breaking change**: The `TagSyntax` is _deprecated_.
* **Breaking change**: `StrikethroughSyntax` now extends
  `DelimiterSyntax` instead of `TagSyntax`.
* **Breaking change**: `LinkSyntax` now extends `DelimiterSyntax`
  instead of `TagSyntax`.
* Add new syntax `DelimiterSyntax`.
* Add support to GFM extension for GitHub task lists (aka checkboxes).  These
  are only active in the `GITHUB_FLAVOURED` and `GITHUB_WEB` extension sets.
* Add support for `#ff0000` color swatches.
* Add two new emphasis syntaxes `EmphasisSyntax.underscore` and
  `EmphasisSyntax.asterisk`.
* Change emoji list to be derived from the GitHub API. The only two emoji that
  visually change are `:cricket:` and `:beetle:`. There are alternate emoji
  `:cricket_game:` and `:lady_beetle:` which can be used to access the previous
  emoji. `update_github_emoji.cr` now pulls all emoji info directly from
  GitHub API and as a result we now support the entire GitHub emoji set
  (excluding the 19 custom GitHub specific emoji which have no Unicode support).

## [0.2.0] - 2023-02-16

* **Breaking change**: Change type of `parse_inline`'s parameters from
  `String?` to `String`.
* Fix table-rendering bug when table rows have trailing whitespace.
* Do not allow reference link labels to contain left brackets.
* Treat lines matching a code block syntax as a continuations of
  paragraphs, inside blockquotes.
* Add syntax for GitLab-flavored blockquotes. GitLab-flavored Markdown
  will be evaluated into an ExtensionSet, in a future release.
* Add `with_default_inline_syntaxes : Bool` and
  `with_default_block_syntaxes : Bool` parameters to `Luce.to_html`
  and `Luce::Document` to support case of specifying exactly the list
  of desired syntaxes.

## [0.1.0] - 2023-02-04

The initial tagged release of Luce. This version has compatibility
with the dart-lang/markdown package version 4.0.1.  You can:

- Parse CommonMark to HTML
- Parse GitHub Flavoured Markdown to HTML
- Parse GitHub Web Markdown to HTML
- Define custom Inline and Block syntaxes
- Define custom Link and Image Link resolvers
- Define custom Extension Sets
- Use any Crystal version from 1.0.0 to 1.7.2

[Unreleased]: https://codeberg.org/supercell/luce/compare/v0.3.0...HEAD
[0.3.0]: https://codeberg.org/supercell/luce/compare/v0.2.0...v0.3.0
[0.2.0]: https://codeberg.org/supercell/luce/compare/v0.1.0...v0.2.0
[0.1.0]: https://codeberg.org/supercell/luce/releases/tag/v0.1.0
