//
//  CFRangeExt.h
//  Manuscript
//
//  Created by 二鏡 on 11/04/12.
//  Copyright 2011 二鏡庵. All rights reserved.
//

#import <CoreFoundation/CoreFoundation.h>


FOUNDATION_STATIC_INLINE CFIndex
_CFRangeLimit(CFRange range)
{
    return range.location+range.length;
}

FOUNDATION_STATIC_INLINE CFRange
_CFRangeSubtract(CFRange base, CFRange sub)
{
    CFIndex baseLimit = _CFRangeLimit(base);
    CFIndex subLimit = _CFRangeLimit(sub);
    return CFRangeMake(subLimit, baseLimit-subLimit);
}

FOUNDATION_STATIC_INLINE BOOL
_CFLocationInRange(CFIndex loc, CFRange range)
{
    return (loc >= range.location && loc < range.location + range.length);
}

FOUNDATION_STATIC_INLINE BOOL
_CFLocationInRangeEQ(CFIndex loc, CFRange range)
{
    return (loc >= range.location && loc <= range.location + range.length);
}

FOUNDATION_STATIC_INLINE BOOL
_CFLocationInClosedRange(CFIndex loc, CFRange range)
{
    return (loc >= range.location && loc <= range.location + range.length);
}

FOUNDATION_STATIC_INLINE CFRange
_CFRangeConstrain(CFRange range, CFRange limit)
{
    CFIndex final = MIN(_CFRangeLimit(range), _CFRangeLimit(limit));
    if(range.location > limit.location)
    {
        return CFRangeMake(range.location, final-range.location);
    }
    else
    {
        return CFRangeMake(limit.location, final-limit.location);
    }
}