//
//  MSScriptExecutor.m
//  Manuscript
//
//  Created by 木谷 洋 on 12/03/31.
//  Copyright (c) 2012年 二鏡庵. All rights reserved.
//

#import "MSScriptExecutor.h"

NSString *MSScriptExecutorExecutionDidEndNotification = @"MSScriptExecutorDidEnd";

@interface MSScriptExecutor ()
@property (readwrite) NSString *result;
@end

@implementation MSScriptExecutor
{
    NSTask *_task;
    NSMutableData *_readingData;
    NSMutableDictionary *_env;
}

@synthesize input, result;
- (id)init
{
    _env = [NSMutableDictionary dictionary];
    
    // デフォルト変数
    id locale = [NSLocale currentLocale];
    id lang = [locale objectForKey: NSLocaleIdentifier];
    [_env setValue: lang 
            forKey: @"LANG"];
    
    return self;
}

- (void)setEnvironmentVariable:(id)val forKey:(NSString*)key
{
    [_env setValue: val forKey: key];
}

- (void)doCommand:(NSURL*)url
{
    // taskを起動してすぐ終了する
    self.result = nil;

    // noneの場合はnilになる
    id writingData = [self.input dataUsingEncoding: NSUTF8StringEncoding];
    _readingData = [NSMutableData data];
    
    _task = [[NSTask alloc] init];
    [_task setLaunchPath: [url path]];

    [_task setEnvironment: _env];
    
    [_task setStandardInput: [NSPipe pipe]];
    [_task setStandardOutput: [NSPipe pipe]];
    
    NSFileHandle *readingHandle = [[_task standardOutput] fileHandleForReading];
    [[NSNotificationCenter defaultCenter] addObserver: self
                                             selector: @selector(_readData:)
                                                 name: NSFileHandleReadCompletionNotification
                                               object: readingHandle];
    [readingHandle readInBackgroundAndNotify];
    
    // execute
    [_task launch];
    
    // start writing
    if( writingData ) {
        NSFileHandle *writingHandle = [[_task standardInput] fileHandleForWriting];
        [writingHandle writeData: writingData];
        [writingHandle closeFile];
    }
}

- (void)_finishExecution
{
    id center = [NSNotificationCenter defaultCenter];
    [center removeObserver: self
                      name: NSFileHandleReadCompletionNotification
                    object: [[_task standardOutput] fileHandleForReading]];
    _task = nil;
    // decode
    if(_readingData)
        self.result = [[NSString alloc] initWithData: _readingData 
                                            encoding: NSUTF8StringEncoding];
    
    [center postNotificationName: MSScriptExecutorExecutionDidEndNotification
                          object: self];
}

- (void)_readData:(id)aNotif
{
    NSData *data = [[aNotif userInfo] objectForKey: NSFileHandleNotificationDataItem];

    if([data length])
    {
        [_readingData appendData: data];

        [[aNotif object] readInBackgroundAndNotify]; // re-buffering
        return; // データが正しく来る限りは読み込みを続ける
    }

    // データがなければ終了。taskの停止を見ておくべき？
    [self _finishExecution];
}

- (void)abortExecution
{
    [_task terminate];
    [[NSNotificationCenter defaultCenter]
     removeObserver: self
     name: NSFileHandleReadCompletionNotification
     object: [[_task standardOutput] fileHandleForReading]];
    _readingData = nil;
    self.result = nil;
    _task = nil;
}
@end
