//
//  ClusterMappingCache.h
//  Fumizuki
//
//  Created by 二鏡 on 11/08/17.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#ifndef VTKit_ClusterMappingCache_h
#define VTKit_ClusterMappingCache_h
#include <CoreFoundation/CoreFoundation.h>

// パラグラフなどの数え上げを記憶するためのキャッシュ構造
// 配列データがクラスター化されてサブグループの列になっている時に
// 元インデックスとクラスターインデックスの対応をキャッシュする
// あるパラグラフまでの総文字数を記憶しておき続きから数えることで、
// リアルタイムの更新を有利に進めることができる
// dirty化対象の一つ前までを記憶する点に注意
class ClusterMappingCache
{
    CFIndex cluster;
    CFIndex index;
public:
    ClusterMappingCache()
    {
        cluster = -1;
        index = -1;
    }
    
    inline void invalidate()
    {
        cluster = -1;
        index = -1;
    }
    
    inline void cache(const CFIndex c, const CFIndex i)
    {
        cluster = c;
        index = i;
    }
    
    inline void get_state(CFIndex& c, CFIndex& i)
    {
        c = cluster;
        i = index;
    }
    
    inline bool valid()
    {
        return cluster != -1;
    }
};

#endif
