//
//  CompiledAttributedString.mm
//  GridTextLayout
//
//  Created by るてい on 11/01/08.
//  Copyright 2011 るてい工房. All rights reserved.
//

#import "CompiledAttributedString.h"

NSString *FZRubyAttributeName = @"FZRubyAttribute";

void
CompiledAttributedString::compile(NSAttributedString* aStr)
{
    NSColor *blackColor = [NSColor blackColor];
    __block AttributesSet attrs;    
    __block id obj;
    __block CFRange cfRange;
    
    // attributes iterator
    typedef void (^IteratorT)(NSDictionary*, NSRange, BOOL*);
    IteratorT iter = ^(NSDictionary *attr, NSRange range, BOOL *stop)
    {        
        // default values
        attrs.font = nil;
        attrs.underlineStyle = 0;
        attrs.strikethroughStyle = 0;
        attrs.foregroundColor = blackColor;
        attrs.backgroundColor = nil;
        attrs.underlineColor = nil;
        attrs.strikethroughColor = nil;
        attrs.ruby = nil;
        attrs.segment = -1;
        
        obj = [attr objectForKey: NSFontAttributeName];
        if(obj)
            attrs.font = obj;
        else
            attrs.font = [NSFont fontWithName: @"Helvetica" size: 12.0];
        obj = [attr objectForKey: NSUnderlineStyleAttributeName];
        if(obj)
            attrs.underlineStyle = [obj intValue];
        obj = [attr objectForKey: NSStrikethroughStyleAttributeName];
        if(obj)
            attrs.strikethroughStyle = [obj intValue];
        obj = [attr objectForKey: NSForegroundColorAttributeName];
        if(obj)
            attrs.foregroundColor = obj;
        obj = [attr objectForKey: NSBackgroundColorAttributeName];
        if(obj)
            attrs.backgroundColor = obj;
        obj = [attr objectForKey: NSUnderlineColorAttributeName];
        if(obj)
            attrs.underlineColor = obj;
        obj = [attr objectForKey: NSStrikethroughColorAttributeName];
        if(obj)
            attrs.strikethroughColor = obj;
        obj = [attr objectForKey: NSMarkedClauseSegmentAttributeName];
        if(obj)
            attrs.segment = [obj intValue];
        obj = [attr objectForKey: FZRubyAttributeName];
        if(obj)
            attrs.ruby = obj;
        // 中身をコピー
        cfRange = CFRangeMake(range.location,range.length);
        attributes.push_back(make_pair(cfRange,attrs));
    };
    
    NSUInteger length = [aStr length];
    
    // copy string
    NSString *string = [aStr string];
    characters.resize(length);
    [string getCharacters: &(characters[0]) range: NSMakeRange(0,length)];
    
    // copy attributes
    [aStr enumerateAttributesInRange: NSMakeRange(0,length)
                             options: 0
                          usingBlock: iter];
}
