//
//  MSPageFormat.h
//  Okusa
//
//  Created by 木谷 洋 on 12/02/11.
//  Copyright (c) 2012年 二鏡庵. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef enum 
{
    eLineSpacingMode_None,
    eLineSpacingMode_Half,
    eLineSpacingMode_Full,
} eLineSpacingMode;

// 要するにコンテナ定義である
@interface MSPageFormat : NSObject

- (id)initWithSpacingMode:(eLineSpacingMode)aMode
                  padding:(NSSize)aPadding
                 fontName:(NSString*)aName
                 fontSize:(CGFloat)aSize
                 boxCount:(NSUInteger)aCount;

@property (readonly) eLineSpacingMode spacingMode;
@property (readonly) NSSize padding;
@property (readonly) NSString *fontName;
@property (readonly) CGFloat fontSize;
@property (readonly) NSFont *font;
@property (readonly) NSUInteger boxCount;

// ex
@property (readonly) CGFloat boxSize;
@property (readonly) CGFloat boundingWidth; // 行間込みのbounding幅
@property (readonly) CGFloat interline; // 行間
@property (readonly) CGFloat lineMarkBorder;

- (NSSize)standardSizeForNewWindow;
- (NSAttributedString*)formatString:(NSString*)string;
@end

