package org.dyndns.nuda.sample;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Structure implements Carrier {	
	/**
	 * 
	 */
	private static final long serialVersionUID = -3603005521575897405L;
	
	
	private List<Carrier> children = new LinkedList<Carrier>();
	private Carrier next;
	private Carrier previous;
	private Carrier parent;
	
	private int index = 0;
	
	@Override
	public Carrier getParent() {
		
		return parent;
	}

	@Override
	public boolean hasParent() {
		if(parent != null) {
			return true;
		} else {
			return false;
		}
	}

	@Override
	public List<Carrier> getChildren() {
		if(children == null) {
			return new LinkedList<Carrier>();
		} else {
			return children;
		}
		
	}

	@Override
	public boolean hasChild() {
		if(children == null) {
			return false;
		} else {
			if(children.size() == 0) {
				return false;
			} else {
				return true;
			}
		}
	}

	@Override
	public int getLength() {
		if(children == null) {
			return 0;
		} else {
			return children.size();
		}
	}

	@Override
	public Carrier getNext() {
		return next;
	}

	@Override
	public Carrier getPrevious() {
		return previous;
	}

	@Override
	public Iterator<Carrier> iterator() {
		return children.iterator();
	}

	@Override
	public int compareTo(Carrier o) {
		if(o == null) {
			return 1;
		} else {
			return this.getIndex() - o.getIndex();
		}
	}

	@Override
	public int getIndex() {
		return index;
	}

	@Override
	public Carrier getChildByIndex(int index) {
		if(children == null) {
			return null;
		} else {
			if(children.size() < index) {
				return null;
			} else {
				return children.get(index);
			}
		}
	}

}
