package org.dyndns.nuda.tools.util;

import static org.dyndns.nuda.tools.util.StringUtilFormatConst.BLACKET;
import static org.dyndns.nuda.tools.util.StringUtilFormatConst.BLACKET_LEFT;
import static org.dyndns.nuda.tools.util.StringUtilFormatConst.BLACKET_LEFT_REPLACE;
import static org.dyndns.nuda.tools.util.StringUtilFormatConst.BLACKET_RIGHT;
import static org.dyndns.nuda.tools.util.StringUtilFormatConst.BLACKET_RIGHT_REPLACE;
import static org.dyndns.nuda.tools.util.StringUtilFormatConst.BLANK;
import static org.dyndns.nuda.tools.util.StringUtilFormatConst.FORMAT_P03D;
import static org.dyndns.nuda.tools.util.StringUtilFormatConst.HAT;
import static org.dyndns.nuda.tools.util.StringUtilFormatConst.NOT_REPLACE_HOLDER;
import static org.dyndns.nuda.tools.util.StringUtilFormatConst.PTN;
import static org.dyndns.nuda.tools.util.StringUtilFormatConst.PTN2;
import static org.dyndns.nuda.tools.util.StringUtilFormatConst.PTN3;
import static org.dyndns.nuda.tools.util.StringUtilFormatConst.REPLACEMENT_HOLDER;
import static org.dyndns.nuda.tools.util.StringUtilFormatConst.TAB;
import static org.dyndns.nuda.tools.util.StringUtilIndentConst.REPLACEMENT;
import static org.dyndns.nuda.tools.util.StringUtilIndentConst.REPLACEMENT_NUM;
import static org.dyndns.nuda.tools.util.StringUtilIndentConst.REPLACEMENT_NUM_PATTERN;
import static org.dyndns.nuda.tools.util.StringUtilIndentConst.REPLACEMENT_PATTERN;
import static org.dyndns.nuda.tools.util.StringUtilSplitCSVRowConst.splitCSVRowPTN;
import static org.dyndns.nuda.tools.util.StringUtilSplitCSVRowConst.splitCSVRowPTN2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.dyndns.nuda.tools.util.filter.AutoReplacementFilter;

/**
 * 
 * 文字列を操作するための様々なユーティリティメソッドが含まれます
 * 
 * 
 * 
 * 
 * <style type="text/css"> .r { color:red; } </style>
 * 
 * @author nkoseki
 * 
 */
public class StringUtil {
	private StringUtil() {
		// インスタンス化させない
	}
	
	public static String loadString(String path) throws IOException {
		StringBuilder b = new StringBuilder();
		if(path == null) {
			return b.toString();
		}
		if(path.isEmpty()) {
			return b.toString();
		}
		
		ClassLoader loader = Thread.currentThread().getContextClassLoader();
		
		InputStream is = null;
		InputStreamReader isr = null;
		BufferedReader br = null;
		
		is = loader.getResourceAsStream(path);
		if(is == null) {
			return b.toString();
		}
		try {
			try {
				isr = new InputStreamReader(is);
				br = new BufferedReader(isr);
				
				while(br.ready()) {
					String line = br.readLine();
					b.append(line).append("\n");
				}
			} finally {
				if(br != null) {
					br.close();
				}
				if(isr != null) {
					isr.close();
				}
				if(is != null) {
					is.close();
				}
			}
		} catch (IOException e) {
			throw e;
		}
		
		return b.toString();
	}
	
	/**
	 * 引数に指定された文字列のインデント解除を行います
	 * 
	 * @param content
	 *            対象文字列
	 * @return インデント解除された文字列
	 */
	public static String deIndent(final String content) {
		String content0 = content;
		//String patternStr0 = "\\t+";
		Pattern p0 =StringUtilIndentConst.p0;
		
		Matcher m0 = p0.matcher(content);
		String replacement = BLANK;
		
		if (m0.find()) {
			replacement = m0.group();
			
			content0 = m0.replaceFirst(BLANK);
		}
		
		StringBuilder b0 = new StringBuilder();
		b0.append(HAT).append(replacement);
		
		Pattern p =
			Pattern.compile(b0.toString(), Pattern.DOTALL
				| Pattern.MULTILINE);
		
		Matcher m = p.matcher(content0);
		
		String replaceItem = BLANK;
		// int i = 0;
		while (m.find()) {
			replaceItem = m.replaceFirst(REPLACEMENT_HOLDER);
			
			m.reset(replaceItem);
		}
		
		replaceItem = replaceItem.replace(REPLACEMENT_HOLDER, BLANK);
		
		return replaceItem;
	}
	
	/**
	 * 第一引数の文字列を第二引数に指定された数値分, タブ文字でインデントを行います
	 * 
	 * @param content
	 *            対象文字列
	 * @param tabCount
	 *            インデントを行う際のタブ個数
	 * @return インデントされた文字列
	 */
	public static String indent(final String content, final int tabCount) {
		String content0 = content;
		// ^((?:[^(<REPLACEMENT>)]).*)$
		Pattern p =REPLACEMENT_PATTERN;
		
		Matcher m = p.matcher(content0);
		
		String replaceItem = "";
		// int i = 0;
		while (m.find()) {
			replaceItem = m.replaceFirst(REPLACEMENT + m.group(1));
			
			m.reset(replaceItem);
			// i++;
		}
		
		//LoggerFactory.getLogger("StringUtil").info("\n{}\n", replaceItem);
		
		StringBuilder tab = new StringBuilder();
		
		for (int i = 0; i < tabCount; i++) {
			tab.append(TAB);
		}
		
		replaceItem = replaceItem.replace(REPLACEMENT, tab.toString());
		
		return replaceItem;
	}
	
	/**
	 * 第一引数の文字列を第二引数に指定された数値数値分, タブ文字でインデントを行います.</br>
	 * このメソッドはindentメソッドとは異なり行の先頭に行番号を付加します
	 * 
	 * @param content
	 *            対象文字列
	 * @param tabCount
	 *            インデントを行う際のタブ個数
	 * @return インデントされた文字列
	 */
	public static String indentWithNum(final String content, final int tabCount) {
		String content0 = content;
		// ^((?:[^(<REPLACEMENT>)]).*)$
		Pattern p =REPLACEMENT_NUM_PATTERN;
		
		Matcher m = p.matcher(content0);
		
		String replaceItem = BLANK;
		// int i = 0;
		int lineNum = 1;
		
		while (m.find()) {
			String lineNumStr = String.format(FORMAT_P03D, lineNum);
			
			StringBuilder b = new StringBuilder();
			b.append(lineNumStr).append(REPLACEMENT_NUM).append(m.group(1));
			
			replaceItem =
				m.replaceFirst(b.toString());
			
			m.reset(replaceItem);
			lineNum++;
		}
		
		StringBuilder tab = new StringBuilder();
		
		for (int i = 0; i < tabCount; i++) {
			tab.append(TAB);
		}
		
		replaceItem = replaceItem.replace(REPLACEMENT, tab.toString());
		
		return replaceItem;
	}
	
	/**
	 * C形式のformatメソッドです. </br>
	 * {}をプレースホルダーとして、第二引数以降に指定したオブジェクトを</br>
	 * 順次割り当てます.
	 * 
	 * @param format
	 *            フォーマット文字列です
	 * @param params
	 *            パラメータ
	 * @return フォーマット済み文字列
	 */
	public static String format(final String format, final Object... params) {
		String result = "";
		if (format == null) {
			return null;
		}
		if (params == null || params.length == 0) {
			result = format;
		} else {
			Matcher m = PTN.matcher(format);
			
			int i = 0;
			while (m.find()) {
				if (i < params.length) {
					if (params[i] != null) {
						
						String replacement = params[i].toString();

						replacement = AutoReplacementFilter.getInstance().replace(replacement);
						
						String replaceResult = m.replaceFirst(replacement);
						
						m.reset(replaceResult);
						result = replaceResult;
						
					} else {
						String replaceResult =
							m.replaceFirst(NOT_REPLACE_HOLDER);
						
						m.reset(replaceResult);
						result = replaceResult;
					}
					
				}
				
				i++;
			}
			
			Matcher m2 = PTN2.matcher(result);
			
			while (m2.find()) {
				String r = m2.replaceFirst(BLACKET);
				m2.reset(r);
				result = r;
			}
		}
		
		result = AutoReplacementFilter.getInstance().repair(result);
		
		return result;
	}
	
	/**
	 * C形式のformatメソッドです.<br>
	 * {KEY}をMAP<KEY, VALUE>によって「VALUE」に変換します
	 * 
	 * @param format
	 *            フォーマット文字列
	 * @param map
	 *            変換マップ
	 * @return フォーマット済み文字列
	 */
	public static String format(final String format,
			final Map<String, Object> map) {
		String result = BLANK;
		if (format == null) {
			return result;
		}
		if (map == null || map.size() == 0) {
			result = format;
		} else {
			Matcher m = PTN3.matcher(format);
			
			//int i = 0;
			while (m.find()) {
				String g = m.group(1);
				Object val = map.get(g);
				
				if (map.containsKey(g)) {
					String replacement = val.toString();

					replacement = AutoReplacementFilter.getInstance().replace(replacement);
					
					String replaceResult = m.replaceFirst(replacement);
					
					m.reset(replaceResult);
					result = replaceResult;
					
				} else if (g.isEmpty()) {
					String replaceResult = m.replaceFirst(NOT_REPLACE_HOLDER);
					
					m.reset(replaceResult);
					result = replaceResult;
				} else {
					
					String group = m.group();
					
					group =
						group
							.replace(BLACKET_LEFT, BLACKET_LEFT_REPLACE)
							.replace(BLACKET_RIGHT, BLACKET_RIGHT_REPLACE);
					
					String replaceResult = m.replaceFirst(group);
					
					m.reset(replaceResult);
					result = replaceResult;
				}
				
				//i++;
			}
			
			Matcher m2 = PTN2.matcher(result);
			
			while (m2.find()) {
				String r = m2.replaceFirst(BLACKET);
				m2.reset(r);
				result = r;
			}
			
			result =
				result.replace(BLACKET_LEFT_REPLACE, BLACKET_LEFT).replace(
					BLACKET_RIGHT_REPLACE,
					BLACKET_RIGHT);
		}
		
		result = AutoReplacementFilter.getInstance().repair(result);
		
		return result;
	}
	
	// ============================= splitCSVRow =================================

	
	/**
	 * <style type="text/css"> .r { color:red; } </style>
	 * 
	 * CSV行を表す文字列を各カラムごとに分解します.</br> CSV行はカンマで区切られた文字列データを表し それぞれのカラムは
	 * <ul>
	 * <li><span class="r">カンマを含まない</span>英数大文字/小文字/, 半角/全角カタカナ, 半角/全角ひらがな, 漢字</li>
	 * <li>「ダブルクォートで囲まれた」<span class="r">カンマを含む</span>英数大文字/小文字/, 半角/全角カタカナ, 半角/全角ひらがな, 漢字, 改行以外の空白文字</li>
	 * </ul>
	 * より成ります
	 * 
	 * @param csvRow
	 *            CSV行
	 * @return カラムリスト
	 */
	public static List<String> splitCSVRow(final String csvRow) {
		List<String> result = new LinkedList<String>();
		
		Matcher m = splitCSVRowPTN.matcher(csvRow);
		
		while (m.find()) {
			String r = m.group();
			Matcher m2 = splitCSVRowPTN2.matcher(r);
			
			if (m2.find()) {
				// ""(ダブルクォートで囲まれている場合)
				result.add(m2.group(1));
			} else {
				// ""(ダブルクォートで囲まれていない場合)
				result.add(r.trim());
			}
			
		}
		
		return result;
	}
	
}
