package org.dyndns.nuda.tools.util;

import java.util.HashMap;
import java.util.Map;

import junit.framework.Assert;
import junit.framework.TestCase;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class StringUtilTest extends TestCase {
	
	@Override
	@Before
	public void setUp() throws Exception {
	}
	
	@Override
	@After
	public void tearDown() throws Exception {
	}
	
	@Test
	public void testDeIndent() {
		String param = "	あいうえお\n	かきくけこ";
		String expected = "あいうえお\nかきくけこ";
		String actual = StringUtil.deIndent(param);
		
		Assert.assertEquals(expected, actual);
	}
	
	public void testIndent() {
		String param = "あいうえお\nかきくけこ";
		String expected = "		あいうえお\n		かきくけこ";
		String actual = StringUtil.indent(param, 2);
		
		Assert.assertEquals(expected, actual);
	}
	
	public void testIndentWithNum() {
		String param = "あいうえお\nかきくけこ";
		String expected = "001 :		あいうえお\n002 :		かきくけこ";
		String actual = StringUtil.indentWithNum(param, 2);
		
		Assert.assertEquals(expected, actual);
	}
	
	@Test
	public void testFormatStringObjectArray01() {
		String message = StringUtil.format("{}", "a.b.c");
		
		Assert.assertEquals(message, "a.b.c", message);
	}
	
	@Test
	public void testFormatStringObjectArray02() {
		String message = StringUtil.format("{}", "a\\b\\c");
		
		Assert.assertEquals(message, "a\\b\\c", message);
	}
	
	@Test
	public void testFormatStringObjectArray03() {
		String message = StringUtil.format("{}", "a?b?c");
		
		Assert.assertEquals(message, "a?b?c", message);
	}
	
	@Test
	public void testFormatStringObjectArray04() {
		String message = StringUtil.format("{}", "a+b+c");
		
		Assert.assertEquals(message, "a+b+c", message);
	}
	
	@Test
	public void testFormatStringObjectArray05() {
		String message = StringUtil.format("{}", "a*b*c");
		
		Assert.assertEquals(message, "a*b*c", message);
	}
	
	@Test
	public void testFormatStringObjectArray06() {
		String message =
			StringUtil.format(
				"{} {} {} {} {}",
				"a.b.c",
				"a\\b\\c",
				"a?b?c",
				"a+b+c",
				"a*b*c");
		
		Assert
			.assertEquals(message, "a.b.c a\\b\\c a?b?c a+b+c a*b*c", message);
	}
	
	@Test
	public void testFormatStringObjectArray07() {
		String message =
			StringUtil.format(
				"{{}} {} {} {{} {}}",
				"a.b.c",
				"a\\b\\c",
				"a?b?c",
				"a+b+c",
				"a*b*c");
		
		Assert.assertEquals(
			message,
			"{a.b.c} a\\b\\c a?b?c {a+b+c a*b*c}",
			message);
	}
	
	@Test
	public void testFormatStringMap01() {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("key01", "a.b.c");
		map.put("key02", "a\\b\\c");
		map.put("key03", "a?b?c");
		map.put("key04", "a+b+c");
		map.put("key05", "a*b*c");
		
		String message =
			StringUtil.format(
				"{{key01}} {key02} {key03} {{key04} {key05}}",
				map);
		
		Assert.assertEquals(
			message,
			"{a.b.c} a\\b\\c a?b?c {a+b+c a*b*c}",
			message);
	}
}
