/*
 * Copyright (c) Daisuke OKAJIMA    All rights reserved.
 * 
 * $Id
 */
using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using System.Diagnostics;

using Travis.Util;

using Zanetti.Commands;
using Zanetti.Indicators;
using Zanetti.Data;
using Zanetti.Forms;
using Zanetti.SystemTrading;
using Zanetti.SystemTrading.AutoTrading;

namespace Zanetti.UI {
	internal class AutoTradingResultPane : System.Windows.Forms.UserControl {
		private AutoTradingResult _result;
		
		private Panel _panel;
		private Button _summaryButton;
		private Button _exportButton;
		private System.Windows.Forms.Label _explanation;
		private ListViewWithCustomKey _listView;
		private System.Windows.Forms.ColumnHeader _colBrand;
		private System.Windows.Forms.ColumnHeader _colSignalDate;
		private System.Windows.Forms.ColumnHeader _colEntryPrice;
		private System.Windows.Forms.ColumnHeader _colResult;
		private System.Windows.Forms.ColumnHeader _colEndDate;
		private System.Windows.Forms.ColumnHeader _colEndPrice;
		private System.Windows.Forms.ColumnHeader _colPerformance;

		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.Container components = null;

		public AutoTradingResultPane(AutoTradingResult result) {
			// ̌ĂяóAWindows.Forms tH[ fUCiŕKvłB
			InitializeComponent();
			this.SetStyle(ControlStyles.DoubleBuffer|ControlStyles.AllPaintingInWmPaint, true);

			_result = result;
			// TODO: InitializeComponent Ăяǒɏǉ܂B
			InitList();
		}

		public int RequiredWidth {
			get {
				return 468;
			}
		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing ) {
			if( disposing ) {
				if(components != null) {
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region R|[lg fUCiŐꂽR[h 
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent() {
			this._panel = new System.Windows.Forms.Panel();
			this._summaryButton = new System.Windows.Forms.Button();
			this._exportButton = new System.Windows.Forms.Button();
			this._explanation = new System.Windows.Forms.Label();
			this._listView = new Zanetti.UI.ListViewWithCustomKey();
			this._colBrand = new System.Windows.Forms.ColumnHeader();
			this._colSignalDate = new System.Windows.Forms.ColumnHeader();
			this._colEntryPrice = new System.Windows.Forms.ColumnHeader();
			this._colResult = new System.Windows.Forms.ColumnHeader();
			this._colEndDate = new System.Windows.Forms.ColumnHeader();
			this._colEndPrice = new System.Windows.Forms.ColumnHeader();
			this._colPerformance = new System.Windows.Forms.ColumnHeader();
			this._panel.SuspendLayout();
			this.SuspendLayout();
			// 
			// _panel
			// 
			this._panel.Controls.Add(this._summaryButton);
			this._panel.Controls.Add(this._exportButton);
			this._panel.Controls.Add(this._explanation);
			this._panel.Dock = System.Windows.Forms.DockStyle.Top;
			this._panel.Location = new System.Drawing.Point(0, 0);
			this._panel.Name = "_panel";
			this._panel.Size = new System.Drawing.Size(144, 72);
			this._panel.TabIndex = 0;
			// 
			// _summaryButton
			// 
			this._summaryButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._summaryButton.Location = new System.Drawing.Point(8, 31);
			this._summaryButton.Name = "_summaryButton";
			this._summaryButton.Size = new System.Drawing.Size(64, 23);
			this._summaryButton.TabIndex = 0;
			this._summaryButton.Text = "Wv(&S)...";
			this._summaryButton.Click += new System.EventHandler(this.OnShowSummary);
			// 
			// _exportButton
			// 
			this._exportButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._exportButton.Location = new System.Drawing.Point(80, 31);
			this._exportButton.Name = "_exportButton";
			this._exportButton.Size = new System.Drawing.Size(80, 23);
			this._exportButton.TabIndex = 1;
			this._exportButton.Text = "GNX|[g(&E)...";
			this._exportButton.Click += new System.EventHandler(this.OnExport);
			// 
			// _explanation
			// 
			this._explanation.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this._explanation.Location = new System.Drawing.Point(8, 4);
			this._explanation.Name = "_explanation";
			this._explanation.Size = new System.Drawing.Size(56, 19);
			this._explanation.TabIndex = 0;
			this._explanation.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// _listView
			// 
			this._listView.Activation = System.Windows.Forms.ItemActivation.OneClick;
			this._listView.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						this._colBrand,
																						this._colSignalDate,
																						this._colEntryPrice,
																						this._colResult,
																						this._colEndDate,
																						this._colEndPrice,
																						this._colPerformance});
			this._listView.Dock = System.Windows.Forms.DockStyle.Fill;
			this._listView.FullRowSelect = true;
			this._listView.GridLines = true;
			this._listView.Location = new System.Drawing.Point(0, 48);
			this._listView.MultiSelect = false;
			this._listView.Name = "_listView";
			this._listView.Size = new System.Drawing.Size(144, 96);
			this._listView.TabIndex = 1;
			this._listView.View = System.Windows.Forms.View.Details;
			this._listView.SelectedIndexChanged += new System.EventHandler(this.OnItemActivated);
			// 
			// _colBrand
			// 
			this._colBrand.Text = "";
			// 
			// _colSignalDate
			// 
			this._colSignalDate.Width = 80;
			// 
			// _colEntryPrice
			// 
			this._colEntryPrice.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this._colEntryPrice.Width = 64;
			// 
			// _colResult
			// 
			this._colResult.Text = "";
			this._colResult.Width = 40;
			// 
			// _colEndDate
			// 
			this._colEndDate.Width = 80;
			// 
			// _colEndPrice
			// 
			this._colEndPrice.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this._colEndPrice.Width = 64;
			// 
			// _colPerformance
			// 
			this._colPerformance.Text = "ptH[}X";
			this._colPerformance.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this._colPerformance.Width = 80;
			// 
			// AutoTradingResultPane
			// 
			this.Controls.Add(this._listView);
			this.Controls.Add(this._panel);
			this.Name = "AutoTradingResultPane";
			this.Size = new System.Drawing.Size(144, 144);
			this._panel.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void InitList() {
			_explanation.Text = _result.Item.Header;
			_listView.SuspendLayout();
			_listView.BeginUpdate();

			
			_colSignalDate.Text = "VOit";
			_colEndDate.Text = "It";
			if(_result.Item.TradingType==TradingType.Long) {
				_colEntryPrice.Text = "wi";
				_colEndPrice.Text = "pi";
			}
			else { //̌؂ł͕\ւ
				_colEntryPrice.Text = "pi";
				_colEndPrice.Text = "wi";
			}

			for(int i=0; i<_result.ResultCount; i++) {
				AddItem(_result.GetAtS(i));
			}
			_listView.EndUpdate();

			_listView.ResumeLayout();
		}

		private void AddItem(SignalResult sr) {
			string[] values = new string[7];
			values[0] = sr.Brand.Name;
			values[1] = Util.FormatShortDate(sr.StartDate);
			if(sr.Result==SignalResultType.Skip) {
				values[2] = "肹";
				for(int i=3; i<=6; i++) values[i] = "";
			}
			else {
				values[2] = sr.StartPrice.ToString("F0");
				if(sr.Result==SignalResultType.Exit || sr.Result==SignalResultType.Losscut) {
					values[3] = PerformanceSymbol(sr.Result, sr.Performance(_result.Item.TradingType));
					values[4] = Util.FormatShortDate(sr.EndDate);
					values[5] = sr.EndPrice.ToString("F0");
					double p = sr.Performance(_result.Item.TradingType);
					values[6] = String.Format("{0:F2}%", p*100);
				}
				else {
					values[3] = "H";
					values[4] = sr.Result==SignalResultType.Draw? Util.FormatShortDate(sr.EndDate) : "";
					values[5] = "";
					values[6] = sr.Result==SignalResultType.Draw? "vmLC" : "s";
				}
			}
			ListViewItem li = new ListViewItem(values);
			li.Tag = sr;
			_listView.Items.Add(li);
		}

		private void OnItemActivated(object sender, EventArgs args) {
			ListView.SelectedListViewItemCollection t = _listView.SelectedItems;
			if(t.Count>0) {
				ListViewItem li = t[0];
				SignalResult sr = li.Tag as SignalResult;
				if(sr!=null) {
					AbstractBrand br = Env.Frame.ChartCanvas.GetBrand();
					if(br!=sr.Brand) CommandExec.ShowBrand(sr.Brand);
					Env.Frame.ChartCanvas.ForceVisibleDate(sr.StartDate, false);
				}
			}
		}

		private void OnShowSummary(object sender, EventArgs args) {
			new AutoTradingSummaryDialog(_result).ShowDialog(this.ParentForm);
		}
		private void OnExport(object sender, EventArgs args) {
			ContextMenu cm = new ContextMenu();
			Util.AddMenuItem(cm, "Nbv{[hփRs[(&C)", new EventHandler(OnCopyResult));
			Util.AddMenuItem(cm, "CSV`ŕۑ(&S)...", new EventHandler(OnSaveResult));
			cm.Show(this, new Point(_exportButton.Left, _exportButton.Bottom));
		}
		private void OnCopyResult(object sender, EventArgs args) {
			ListViewUtil.CopyListViewContentToClipboard(_listView, new ListViewUtil.ItemChecker(ListViewItemChecker));
		}
		private void OnSaveResult(object sender, EventArgs args) {
			ListViewUtil.SaveListViewContentToFile(_listView, new ListViewUtil.ItemChecker(ListViewItemChecker));
		}
		private bool ListViewItemChecker(ListViewItem li) {
			return true; //Ƀf[^͗L
		}

		private static string PerformanceSymbol(SignalResultType r, double p) {
			//̓ptH[}X̕Exit/LosscutɈv邪ȀɂĂ͂͂ȂȂ̂ŋ
			if(r==SignalResultType.Exit) {
				if(p > 0)
					return "";
				else
					return "(ʂ͑)";
			}
			else if(r==SignalResultType.Losscut) {
				if(p < 0)
					return "~";
				else
					return "~(ʂ͗v)";
			}
			else {
				Debug.Assert(false); //should not reach here
				return null;
			}
		}
	}
}
