#pragma once
#include <boost\thread.hpp>
#include "define.h"
#include "http.h"
#include "windowsAPI.h"
#include "singleton.h"


#include "namespace_start.h"

struct BugTransfer{
	NString summary;
	NString line;
	NString sourcefile;
	NString function;
	NString windowsErrorCode;
	NString windowsErrorMessage;
	


public:
	Bool Report()const;

};



class CBugReporter:public SingletonT<CBugReporter>{

private:
	boost::thread_group m_threadgroup;


public:
	CBugReporter();

	~CBugReporter();



public:
	Void Report(const BugTransfer& bug);


};

#include "namespace_end.h"