#pragma once
#include <atlfile.h>
#include <deque>
#include <nlite_common\nexception.h>
#include "define.h"
#include "cookieGetResult.h"
#include "cookie.h"
#include "copycookiefilemanager.h"
#include "namespace_start.h"
#include "unit_test.h"
template<typename T>
class CCookieGetterT{
	friend Void UnitTest();


protected:
	typedef std::deque<CCookieGetResult> CCookieGetResultList;
	static browsertype::BrowserType BT;

	CCookieGetResultList resultList;
public:

	const CCookieGetResultList&GetCookieGetResultList(){

		return resultList;
	}

	~CCookieGetterT(){

		for each(CCookieGetResult rslt in resultList){

			rslt.Report();
		}

	}
	
	Bool GetCookie(const NString &domein,const NString &name,CCookie &cookie){

		resultList.clear();
	
		cookie.SetDomein(domein);
	
		cookie.SetName(name);
		return (reinterpret_cast<T*>(this))->GetCookieInternal(domein,name,cookie);

	}
	

protected:

	Bool GetCookieInternal(const NString &domein,const NString &name,CCookie &cookie){

			throw Exception(_T("GetCookieInternalĂ܂"),__LINE__,_T(__FILE__),_T(__FUNCTION__));
		return false; 

	}

	

	
};

namespace force{
	template <typename T>
	Bool ForceSearch___(const NString &fileName,const NString &domein,const NString &name,CCookie &cookie,T functa){


		CAtlFile file;
		CHResult result = file.Create(fileName.c_str(), GENERIC_READ, FILE_SHARE_WRITE | FILE_SHARE_READ, OPEN_EXISTING);
		if(!result.IsS_OK()){

			return false;
		}
		CAtlFileMapping<> mapping;
		mapping.MapFile(file);
		return functa(static_cast<Byte*>(mapping.GetData()),mapping.GetMappingSize(),domein,name,cookie);
	
	}
}

template<typename T>
Bool ForceSearch(const NString &fileName,const NString &domein,const NString &name,CCookie &cookie,T functa){

	Bool result = force::ForceSearch___(fileName,domein,name,cookie,functa);

	if(result == false){

		CCopyCookieFile copyCookie(fileName);

		result = force::ForceSearch___(copyCookie.GetFilePath(),domein,name,cookie,functa);

	}

	return result;
}



	

#include "namespace_end.h"