/*
 * CtrlDemoCircleMoveA.cpp
 *
 *  Created on: 2009/03/19
 *      Author: sambuichi
 */

#include "RtStk.h"
#include "AppGridSynth.h"
#include "graphic/GlutMain.h"
#include "graphic/updater/UpdaterGrPort.h"
#include "graphic/text/FTLabelFactory.h"
#include "SoundUtil.h"
#include "Layout.h"

AppGridSynth::AppGridSynth() :
	mouseLPressing(0),
	ctrlCC(16),
	gsheet(Layout::defaultGridRow, Layout::defaultGridCol, width, height, this),
	gpos(gsheet, this),
	gposCtrl(this, gpos),
	figureFactory(gsheet, this),
	seqAreaCtrl(figureFactory, width, height),
	gridEventView(figureFactory, gsheet),
	inputEventToSeqMessage(width_over, height_over),
	mouseEventDrawer(figureFactory, width_over, height_over),
	gridEventDrawer(figureFactory, width_over, height_over),
	synthLabel(this, Layout::currentSynthNamePosX, Layout::currentSynthNamePosY),
	stepPatternSelector(this),
//	vstiParamList(0),
	cnt(0)
{
	DeclareName;
	printfunc;	

	addWindowListener(&gsheet);
	addSynthChangedListener(this);
}

AppGridSynth::~AppGridSynth() {
	// TODO Auto-generated destructor stub
}

void AppGridSynth::update()
{
//	printfunc
}

void AppGridSynth::draw()
{
}

/*!
 * Sequence폜i֘A̓CxgEV[PXGA폜j
 */
inline void AppGridSynth::deleteSequence(Sequence *seq)
{
	for(int k = 0; k < (int)seq->size(); k++) {	//! InputEventseqMessageɑΉInputEvent폜
		inputEvents.remove(seq->at(k).id);
	}
	seqAreaCtrl.remove(seq);		//!	SequenceAreaseqɑΉGA\E폜
	gridEventView.remove(seq->getID());
	removeFromSequencer(seq);	//! SynthForm̃V[PTseq菜č폜
}

/*!
 * [I[o[Sequence폜i֘A̓CxgEV[PXGA폜j
 */
inline void AppGridSynth::deleteRolloverSequence()
{
	vector<Sequence*> &rolloverSeq = seqAreaCtrl.getRolloverSeq();
//	for(int i = 0; i < (int)rolloverSeq.size(); i++) {
//		deleteSequence(rolloverSeq.at(i));
//	}
	vector<int> ids = gridEventView.getPointedEventIDs();
	for(vector<int>::iterator itr = ids.begin(); itr != ids.end(); itr++) {
		Sequence *seq = getSequence((int)*itr);
		deleteSequence(seq);
	}
}

/*!
 * Metrodiac̃R[obN
 */
void AppGridSynth::metroEvent(Metro *metro)
{
	printfunc
	StepPattern *sp = stepPatternSelector.getCurrent();
	if((sp->at(metro->getBeatCount()).value) != 0) {

		int recording = 0;
		if(KEY_CTRL) {	// CTRLȂ烌R[fBOԂƂ
			recording = 1;
		}
		if(mouseLPressing) { // hbO
			float stepPatternDuration = sp->at(metro->getBeatCount()).duration;		//! stepPatterñXebv
			float duration = metro->getDiacDuration()*stepPatternDuration;		//! Xebv̎ԊZ
			float time = metro->getCurrentTime();

//			eventCtrl.input()

//			cout << "note time : " << time << "   seq_length : " << currentSequence->getLength() << "   duration " << metro->getDiacDuration() << endl;
//			inputEventToSeqMessage.mouseToNote(mousex(), mousey(),
//					time, duration, recording, inputEvents, currentSequence);

			int x = mousex();
			int y = mousey();
			float nx = x * width_over;
			float ny = y * height_over;
			int note = n2majorNote(ny, 72, 48);
			float velocity = n2float(nx, 60, 127);

			int noteOnID = currentSequence->addNoteOn(note, velocity, time, recording);
			int noteOffID = currentSequence->addNoteOff(noteOnID, time+duration, recording);

//			inputEvents.put(noteOnID, INPUT_TYPE_MOUSE, x, y, INPUT_STATE_PRESS, time, duration);
//			inputEvents.put(noteOffID, INPUT_TYPE_MOUSE, x, y, INPUT_STATE_RELEASE, time, duration);

			if(lastDrug.getHitNameDepth(0) == 2) {
				int gridCol = (int)lastDrug.getHitName(0, 0);
				int gridRow = (int)lastDrug.getHitName(0, 1);
				cout << "row=" << gridRow << "   col=" << gridCol << endl;
				inputEvents.put(noteOnID, INPUT_TYPE_GRID, gridCol, gridRow, INPUT_STATE_PRESS, time, duration);
			}

			//! }EXʒűŃVZCC𓮂
			float value = distancei(pressx, pressy, mousex(), mousey()) * 127 * 3;
			if(value < 0) { value *= -1; }
			int id = currentSequence->addCC(ctrlCC, value, metro->getCurrentTime(), recording);
			
			inputEvents.put(id, INPUT_TYPE_MOUSE, mousex(), mousey(), INPUT_STATE_MOUSE_DRUG, time, duration);
		}
	}

	SequenceManage::metroEvent(metro);
}


/*!
 * L[{[h͂̃R[obN
 */
void AppGridSynth::keyFunc(int key, int action)
{
	printfunc
	switch(key) {
		//case GLFW_KEY_LSHIFT:		// VtgE[XSynthp[^
	case 'z':		// VtgE[XSynthp[^
		if(action == KEY_RELEASE) {
#if 0
			if(vstiParamList) {
				ctrlCC = vstiParamList->getSelectedIndex();
				vstiParamList->die();
				vstiParamList = 0;		//! 폜ꂽ̂Ń|C^[
			}
#endif
		}
		break;
	case 'r':		// Rg[E[XŃV[PXL^
		cout << "   r KEY" << endl;
		if(action == KEY_RELEASE) {
			Sequence *seq = seqRecEnd();	// V[PXL^IŁAL^V[PXԂ
			seqAreaCtrl.entryInputArea(seq, inputEvents);	// seq̃V[PXGAo^
			vector<InputEvent> ies = inputEvents.get(seq->getMessageIDs());
			gridEventView.entryEvents(seq->getID(), ies);	// seq̃V[PXGAo^
//			seqArea.show(seq);// L^V[PX̕`A`nh}bvɒǉ
//			seqArea.hide(seq);
		}
		break;
	case KEY_SPACE:
		cout << "   SPACE KEY" << endl;
		sequencesMutex.lock();
		if(action == KEY_PRESS) {
			seqAreaCtrl.showAll();	//! ׂẴV[PX̃GA`悷
			gridEventView.show();
		} else if(action == KEY_RELEASE) {
			seqAreaCtrl.hideAll();	//! ׂẴV[PX̃GA`폜
			gridEventView.hide();
		}
		sequencesMutex.unlock();
	}
}

//! }EXNbÑR[obN
void AppGridSynth::mouseButton(int pos, int state)
{
	printfunc
	mouseLPressing = state;	//! }EXPress, ReleaseԂ̕ێ
	pressx = mousex();
	pressy = mousey();

	switch(pos) {
	case GLUT_LEFT_BUTTON:	//! NbN
		if(state) {	//! press
			synthLabel.select(mousex(), mousey());
			gposCtrl.press(currentSynth, pressx, pressy);
			gsheet.mousePick(pressx, pressy, lastPress);
			gsheet.mousePick(pressx, pressy, lastDrug);
		}
		break;
	case GLUT_RIGHT_BUTTON:	//! ENbN
		if(state) {
			deleteRolloverSequence();	//! [I[õV[PXGA폜
			return;
		}
		break;
	case GLUT_MIDDLE_BUTTON:	//! zC[NbN
		if(state) {
			for(int i = 0; i < (int)sequences.size(); i++) {	//! V[PX̑SNA
				deleteSequence(sequences.at(i));
			}
		}
		break;
	}

	stepPatternSelector.mouseFunction(mousenx(), mouseny(), state);
}

/*!
 * }EXƂ̃R[obN
 */
void AppGridSynth::mousePosition(int x, int y)
{
	printfunc
	if(!mouseLPressing) {
		gpos.position(mousenx(), mouseny());	//! Grid|WV`ʒuXV
		seqAreaCtrl.rollover(x, y);				//! V[PXGÃ[I[oi\̂݁j
		gridEventView.point(x, y);
		synthLabel.rollover(x, y);				//! VZx̃[I[o
		gposCtrl.position(x, y);
	} else {	// Drug
		gsheet.mousePick(x, y, lastDrug);
	}

	stepPatternSelector.move(mousenx(), mouseny());
}

//! }EXEzC[̃R[obN
void AppGridSynth::mouseWheel(int val)
{
//	printfunc
	static int lastVal = 0;
	int relativeVal = val - lastVal;
	lastVal = val;

	gposCtrl.mouseWheel(val);	// Row, Col Ώۂ̑I[h̏ꍇAy[W߂

	if(KEY_CTRL) {
		int gridScaleNum = (relativeVal < 0) ? -3 : 3;
		gsheet.gridScale(gridScaleNum);
		gsheet.drawSheet();
	}
}

//! VZύXꂽƂ̃R[obN
void AppGridSynth::synthChanged(Synth *synth)
{
	printfunc
	//! 삷MIDI CC̃CfbNXVVZōől𒴂Ȃ悤ɒ
	int numParam = synth->getNumParams();
	if(ctrlCC >= numParam) {
		ctrlCC = (numParam - 1);
	}
	cout << synth->getChannel() << endl;
	setSequenceChannel(synth->getChannel());
	synthLabel.set(synth);
}

/*!
 * V[PXbZ[WꂽƂɌĂяo
 */
void AppGridSynth::sequencerEventProcessed(Sequence *seq, Sequence::Message &smsg)
{
	printfunc
	InputEvent event = inputEvents.get(smsg.id);

	switch(event.type) {
	case INPUT_TYPE_MOUSE:
		mouseEventDrawer.eventDrawProc(seq, smsg, event);
		break;
	case INPUT_TYPE_GRID:
		gridEventDrawer.eventDrawProc(seq, smsg, event);
		break;
	case INPUT_TYPE_KEY:
		break;
	}

	if(!smsg.loop) {	// Sequence::Messagẽ[vIŃV[PX폜Ă邽
		inputEvents.remove(smsg.id);	// Sequence::MessageɑΉInputEvent폜
	}
}

void AppGridSynth::windowSizeChanged(int width, int height)
{
	this->width = width;
	this->height = height;
}
