/*
 * GridEventDrawer.h
 *
 *  Created on: 2009/11/15
 *      Author: ox
 */

#ifndef GRIDEVENTDRAWER_H_
#define GRIDEVENTDRAWER_H_

#include "sound/Sequence.h"
#include "graphic/comp/InputEvents.h"
#include "graphic/comp/GridFigure.h"

class GridEventDrawer {
public:
	GridEventDrawer(GridFigureFactory &figureFactory, float width_over, float height_over);
	virtual ~GridEventDrawer();

	void eventDrawProc(Sequence *seq, Sequence::Message &smsg, InputEvent &event);

private:
	GridFigureFactory &figureFactory;
	float width_over;
	float height_over;

	map<int,InputEvent> lastInputEventMap;

	float cellLineShowDurationRatio;	//! cellLine`JnAlphalőɂȂ܂ł̎ԁiDurationɑ΂Wj
	float cellLineHideDurationRatio;	//! cellLine`Alphalő傩ŏɂȂ܂ł̎ԁiDurationɑ΂Wj
	float cellLineAlpha;				//! őAlphal
	void setCellLineShowDurationRatio(float ratio) { this->cellLineShowDurationRatio = ratio; }
	void setCellLineHideDurationRatio(float ratio) { this->cellLineHideDurationRatio = ratio; }
	void setCellLineAlpha(float alpha) { this->cellLineAlpha = alpha; }
	void drawCellLine(InputEvent &ie1, InputEvent &ie2);


	float inputPointDurationRatio;		//! inputPoint`掞ԁiDurationɑ΂Wj
	float inputPointAlpha;				//! őAlphal
	void setInputPointDurationRatio(float ratio) { this->inputPointDurationRatio = ratio; }
	void setInputPointAlpha(float alpha) { this->inputPointAlpha = alpha; }
	void drawInputPoint(InputEvent &ie);
};

#endif /* GRIDEVENTDRAWER_H_ */
