/*
 * Layout.h
 *
 *  Created on: 2009/09/17
 *      Author: sambuichi
 */

#ifndef LAYOUT_H_
#define LAYOUT_H_

#include "graphic/port/Colorful.h"

struct Layout {
	static const unsigned int defaultGridRow;
	static const unsigned int defaultGridCol;

	static const float currentSynthNamePosX = 0.03;
	static const float currentSynthNamePosY = 0.10;

	static const float synthSelectLabelSize = 0.05;
	static const float synthSelectListItemSize = 0.04;
	static const float synthSelectListItemMargin = 0.01;

	static const Colorful SynthSelectLabelColor;
	static const Colorful SynthSelectListColor;
	static const Colorful SequenceAreaLabelColor;
	static const Colorful StepPatternColor;
	static const Colorful StepPatternListColor;
	static const Colorful StepPatternListHighlightColor;

	static const float stepPatternSize 				= 0.02;
	static const float stepPatternX		 			= 0.03;
	static const float stepPatternY		 			= 0.20;
	static const float stepPatternRectsRatio 			= 0.1;
	static const float stepPatternListRectsRatio 		= 0.1;

	static const float stepPatternListX		 		= 0.03;
	static const float stepPatternListY		 		= 0.20;
	static const float stepPatternListLabelSize 		= 0.02;
	static const float stepPatternListRectSize 		= 0.02;
	static const float stepPatternListLabelRectMargin = 0.005;
	static const float stepPatternListItemMargin 		= 0.02;
	static const float stepPatternListItemSize;

	static const float eventDrawerInputPointAlpha;
	static const float eventDrawerInputPointDuration;

	static const float eventDrawerInputConnectAlhpa;
	static const float eventDrawerInputConnectShow;
	static const float eventDrawerInputConnectHide;

	//! SeqTrajectory
	static const Colorful SeqTrajColor;
	static const Colorful SeqTrajHighColor;

	//! ListCtrl
	static const float listPosX;
	static const float listPosY;
	static const float listHeight;
	static const int numShowListItem;
};



#endif /* LAYOUT_H_ */
