/*
 * SeqCtrl.cpp
 *
 *  Created on: 2009/10/20
 *      Author: ox
 */

#include "SeqAreaCtrl.h"
#include "graphic/comp/InputEvents.h"
#include "graphic/updater/UpdaterGrPort.h"
#include "graphic/updater/UpdaterKillUnit.h"
#include "graphic/text/FTLabelFactory.h"
#include "Layout.h"

SeqAreaCtrl::SeqAreaCtrl(GridFigureFactory &figureFactory, float width, float height) :
	figureFactory(figureFactory), width(width), height(height), sequenceAreaViewing(false)
{
//	width_over = 1.0 / width;
//	height_over = 1.0 / height;
}

SeqAreaCtrl::~SeqAreaCtrl() {
	seqAreaMutex.lock();
	for(unsigned int i = 0; i < seqAreas.size(); i++) {
		delete seqAreas.at(i);
	}
	for(unsigned int i = 0; i < seqTrajs.size(); i++) {
		delete seqTrajs.at(i);
	}
	seqAreaMutex.unlock();
}

//! w肵Seq̃GA\
void SeqAreaCtrl::show(Sequence* seq)
{
	seqAreaMutex.lock();
	SequenceArea *seqArea = seqAreaMap[seq];
	seqArea->show();
	SeqTrajectory *seqTraj = seqTrajMap[seq];
	seqTraj->show();
	seqAreaMutex.unlock();
}

//! w肵Seq̃GA\ɂ
void SeqAreaCtrl::hide(Sequence* seq)
{
	seqAreaMutex.lock();
	SequenceArea *seqArea = seqAreaMap[seq];
	seqArea->hide();
	SeqTrajectory *seqTraj = seqTrajMap[seq];
	seqTraj->hide();
	seqAreaMutex.unlock();
}

//! o^Ă邷ׂĂSeqGA\
void SeqAreaCtrl::showAll()
{
	seqAreaMutex.lock();
	for(unsigned int i = 0; i < seqAreas.size(); i++) {
		seqAreas.at(i)->show();
	}
	for(unsigned int i = 0; i < seqTrajs.size(); i++) {
		seqTrajs.at(i)->show();
	}
	seqAreaMutex.unlock();
	sequenceAreaViewing = true;
}

//! o^Ă邷ׂĂSeqGA\ɂ
void SeqAreaCtrl::hideAll()
{
	seqAreaMutex.lock();
	for(unsigned int i = 0; i < seqAreas.size(); i++) {
		seqAreas.at(i)->hide();
	}
	for(unsigned int i = 0; i < seqTrajs.size(); i++) {
		seqTrajs.at(i)->hide();
	}
	seqAreaMutex.unlock();
	sequenceAreaViewing = false;
}

/*!
 * seqInputEvent̒őAŏlGA쐬Ao^
 */
void SeqAreaCtrl::entryInputArea(Sequence *seq, InputEvents &inputEvents)
{
	seqAreaMutex.lock();
	SequenceArea *seqArea = new SequenceArea(figureFactory, seq, inputEvents, width, height);
	seqAreas.push_back(seqArea);
	seqAreaMap.insert(map<Sequence*,SequenceArea*>::value_type(seq, seqArea));
	SeqTrajectory *seqTraj = new SeqTrajectory(figureFactory, seq, inputEvents, width, height);
	seqTrajs.push_back(seqTraj);
	seqTrajMap.insert(map<Sequence*,SeqTrajectory*>::value_type(seq, seqTraj));
	seqAreaMutex.unlock();
}

//! o^Ă邷ׂĂseqGAɂă[I[os
void SeqAreaCtrl::rollover(int x, int y) {
	seqAreaMutex.lock();
	for(unsigned int i = 0; i < seqAreas.size(); i++) {
		if(seqAreas.at(i)->rollover(x, y)) {
			seqTrajs.at(i)->highlight(seqAreas.at(i)->isRollover());
		}
	}
//	for(unsigned int i = 0; i < seqTrajs.size(); i++) {
//		seqTrajs.at(i)->rollover(x, y);
//	}
	seqAreaMutex.unlock();
}
