/*
 * StepPatternDraw.h
 *
 *  Created on: 2009/10/07
 *      Author: ox
 */

#ifndef STEPPATTERNDRAW_H_
#define STEPPATTERNDRAW_H_

#include <vector>
#include "graphic/primitive/Rect.h"
#include "graphic/port/Colorful.h"
#include "graphic/mng/UnitMng.h"
#include "StepPattern.h"

class StepPatternDraw {
public:
	StepPatternDraw(StepPattern *pattern,
			float x, float y, float size, float rectsRatio, UnitMng *mng);
	virtual ~StepPatternDraw();

	bool isArea(float x, float y);
	void setPos(float x, float y);
	void setRectsSize(float size);
	void setColor(const Colorful &col);
	void setColor(float r, float g, float b, float a);

	void setPattern(StepPattern *pattern);
	void visible(bool v);
	void movey(float my);
	vector<Rect*> &getStepRects() { return stepRects; }

private:
	void clearAll();

	StepPattern *pattern;
	float x, y;
	float size;
	float rectsRatio;
	float rectsMargin;
	float totalWidth;
	UnitMng *mng;
	vector<Rect*> stepRects;
};

#endif /* STEPPATTERNDRAW_H_ */
